/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.Binding;
import org.eclipse.rcptt.ecl.core.Block;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Pipeline;
import org.eclipse.rcptt.ecl.core.Sequence;
import org.eclipse.rcptt.ecl.core.With;
import org.eclipse.rcptt.ecl.core.util.ScriptletFactory;

public class EclRefactoring
extends ScriptletFactory {
    public static List<Command> align(List<Command> commands) {
        ArrayList<Command> newCommands = new ArrayList<Command>();
        for (Command c : commands) {
            if (c instanceof Sequence) {
                newCommands.addAll((Collection<Command>)((Sequence)c).getCommands());
                continue;
            }
            newCommands.add(c);
        }
        return newCommands;
    }

    public static List<Command> exclude(List<Command> commands, Command ex) {
        int size = commands.size();
        int i = 0;
        while (i < size) {
            Command command = commands.get(i);
            if (command instanceof Block) {
                Block block = (Block)command;
                EclRefactoring.exclude(block.getCommands(), ex);
            }
            if (command.equals(ex)) {
                commands.remove(i);
                --size;
                continue;
            }
            ++i;
        }
        return commands;
    }

    public static List<Command> withify(List<Command> commands) {
        return EclRefactoring.withify(commands, new Comparator<Command>(){

            @Override
            public int compare(Command c1, Command c2) {
                return EcoreUtil.equals((EObject)c1, (EObject)c2) ? 0 : 1;
            }
        });
    }

    public static List<Command> withify(List<Command> commands, Comparator<Command> comparator) {
        ArrayList<Command> newCommands = new ArrayList<Command>();
        int i = 0;
        while (i < commands.size()) {
            Pipeline pipeline;
            Command command = commands.get(i);
            if (command instanceof Pipeline && (pipeline = (Pipeline)command).getCommands().size() > 1) {
                ArrayList<Command> toCollapse = new ArrayList<Command>();
                toCollapse.add(EclRefactoring.getTail(pipeline));
                Command object = (Command)pipeline.getCommands().get(0);
                int j = i + 1;
                while (j < commands.size()) {
                    Pipeline nextPipeline;
                    Command next = commands.get(j);
                    if (!(next instanceof Pipeline) || comparator.compare(object, (Command)(nextPipeline = (Pipeline)next).getCommands().get(0)) != 0) break;
                    toCollapse.add(EclRefactoring.getTail(nextPipeline));
                    ++j;
                }
                if (toCollapse.size() > 1) {
                    newCommands.add(EclRefactoring.makeWith(object != null ? (Command)EcoreUtil.copy((EObject)object) : null, EclRefactoring.makeSeq(EclRefactoring.withify(toCollapse, comparator))));
                } else {
                    newCommands.add(command);
                }
                i = j;
                continue;
            }
            newCommands.add(command);
            ++i;
        }
        return EclRefactoring.mergeNestedWithCommands(newCommands);
    }

    public static List<Command> mergeNestedWithCommands(List<Command> commands) {
        ArrayList<Command> newCommands = new ArrayList<Command>();
        for (Command command : commands) {
            if (command instanceof With) {
                command = EclRefactoring.mergeNestedWithCommands((With)command);
            }
            newCommands.add(command);
        }
        return newCommands;
    }

    public static With mergeNestedWithCommands(With withCommand) {
        Command single;
        Sequence seq;
        Command doCommand = withCommand.getDo();
        if (doCommand instanceof Sequence && (seq = (Sequence)doCommand).getCommands().size() == 1 && (single = (Command)seq.getCommands().get(0)) instanceof With) {
            doCommand = single;
        }
        if (doCommand instanceof With) {
            Binding binding;
            With internalWith = EclRefactoring.mergeNestedWithCommands((With)doCommand);
            Command first = null;
            Command second = null;
            if (withCommand.getBindings().size() == 1 && (binding = (Binding)withCommand.getBindings().get(0)).getFeature().getFeatureID() == 2) {
                first = binding.getCommand();
            }
            if (internalWith.getBindings().size() == 1 && (binding = (Binding)internalWith.getBindings().get(0)).getFeature().getFeatureID() == 2) {
                second = binding.getCommand();
            }
            Pipeline newObject = EclRefactoring.makePipe(first, second);
            Command newDo = internalWith.getDo();
            With newWith = EclRefactoring.makeWith(newObject, newDo);
            return newWith;
        }
        return withCommand;
    }

    public static Command getTail(Pipeline pipeline) {
        EList<Command> commands = pipeline.getCommands();
        if (commands.size() == 2) {
            return commands.get(1) != null ? (Command)EcoreUtil.copy((EObject)((Command)commands.get(1))) : null;
        }
        Pipeline tail = CoreFactory.eINSTANCE.createPipeline();
        int i = 1;
        while (i < commands.size()) {
            tail.getCommands().add(commands.get(i) != null ? (Command)EcoreUtil.copy((EObject)((Command)commands.get(i))) : null);
            ++i;
        }
        return tail;
    }
}

