/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.core;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.IStackListener;
import org.eclipse.rcptt.ecl.internal.core.DeclarationContainer;

public class CommandStack {
    private DeclarationContainer locals;
    private final Command command;
    private final CommandStack parent;
    private static CopyOnWriteArrayList<IStackListener> listeners = new CopyOnWriteArrayList();

    public CommandStack(Command command, CommandStack parent) {
        this.command = command;
        this.parent = parent;
        this.locals = new DeclarationContainer(parent == null ? null : parent.locals);
    }

    public DeclarationContainer getDeclarations() {
        return this.locals;
    }

    public Command getCommand() {
        return this.command;
    }

    public CommandStack getParent() {
        return this.parent;
    }

    public static void addListener(IStackListener listener) {
        listeners.addIfAbsent(listener);
    }

    public static void removeListener(IStackListener listener) {
        listeners.remove(listener);
    }

    public static void fireEnter(CommandStack stack) {
        for (IStackListener l : listeners) {
            l.enter(stack);
        }
    }

    public static void fireExit(CommandStack stack) {
        for (IStackListener l : listeners) {
            l.exit(stack);
        }
    }
}

