/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathNodes;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class DmgExtract {
    private static final XPathExpression KEYS;

    static {
        try {
            KEYS = XPathFactory.newInstance().newXPath().compile("plist/dict/array/dict/key[text()=\"mount-point\"]/following-sibling::string[1]");
        }
        catch (XPathExpressionException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void extract(Path dmgPath, Path target) throws IOException, InterruptedException {
        List<String> mountpoints;
        assert (Files.isRegularFile(dmgPath, new LinkOption[0]));
        assert (Files.isDirectory(target, new LinkOption[0]));
        ProcessBuilder processBuilder = new ProcessBuilder("hdiutil", "attach", "-nobrowse", "-readonly", "-plist", dmgPath.toString());
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = processBuilder.start();
        try {
            Throwable throwable = null;
            Iterator<String> iterator = null;
            try (InputStream output = process.getInputStream();){
                mountpoints = DmgExtract.parseMountPoints(output);
                DmgExtract.completeProcess(process, String.valueOf(processBuilder.command()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            process.destroy();
        }
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        for (String point : mountpoints) {
            try {
                DmgExtract.copyFolder(Paths.get(point, new String[0]), target, LinkOption.NOFOLLOW_LINKS);
            }
            catch (Throwable throwable) {
                processBuilder.command("hdiutil", "detach", point);
                DmgExtract.completeProcess(processBuilder.start(), String.valueOf(processBuilder.command()));
                throw throwable;
            }
            processBuilder.command("hdiutil", "detach", point);
            DmgExtract.completeProcess(processBuilder.start(), String.valueOf(processBuilder.command()));
        }
    }

    public static void copyFolder(final Path source, final Path target, final CopyOption ... options) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(target.resolve(source.relativize(dir).toString()), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, target.resolve(source.relativize(file).toString()), options);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void completeProcess(Process process, String description) throws IOException, InterruptedException {
        try {
            if (!process.waitFor(100L, TimeUnit.SECONDS)) {
                throw new IOException(description + " has timed out");
            }
            if (process.exitValue() != 0) {
                throw new IOException(description + " has exited with code " + process.exitValue());
            }
        }
        finally {
            process.destroy();
        }
    }

    private static List<String> parseMountPoints(InputStream plist) throws IOException {
        try {
            Document dom = DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder().parse(plist);
            XPathNodes result = KEYS.evaluateExpression(dom, XPathNodes.class);
            return StreamSupport.stream(result.spliterator(), false).map(Node::getTextContent).toList();
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new IOException(e);
        }
    }
}

