/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.properties.view;

import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.tesla.core.protocol.PartUIElement;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.properties.view.PropertiesViewPlugin;
import org.eclipse.rcptt.tesla.recording.aspects.IAbstractSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.IBasicSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.SWTEventManager;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTEventRecorder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyList;
import org.osgi.framework.Bundle;

public class PropertiesViewRecorder
implements IRecordingProcessor,
IBasicSWTEventListener {
    private SWTUIPlayer internalPlayer;
    private TeslaRecorder teslaRecorder;
    private SWTEventRecorder swtRecorder;
    private boolean noClassDefLogged = false;

    public PropertiesViewRecorder() {
        SWTEventManager.addListener((IAbstractSWTEventListener)this);
    }

    public void initialize(TeslaRecorder teslaRecorder) {
        this.teslaRecorder = teslaRecorder;
    }

    public void clear() {
    }

    public void setFreeze(boolean value, SetMode command) {
    }

    public void resetAssertSelection() {
    }

    public IRecordingHelper<?> getHelper() {
        return null;
    }

    public int getInitLevel() {
        return 30;
    }

    public boolean isExclusiveEventHandle(Widget widget, int type, Event event) {
        try {
            return widget instanceof TabbedPropertyList.ListElement || widget instanceof TabbedPropertyList.BottomNavigationElement || widget instanceof TabbedPropertyList.TopNavigationElement;
        }
        catch (NoClassDefFoundError e) {
            this.logOnce(e);
            return false;
        }
    }

    private void logOnce(NoClassDefFoundError e) {
        Object message;
        if (this.noClassDefLogged) {
            return;
        }
        this.noClassDefLogged = true;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.views.properties.tabbed");
        if (bundle == null) {
            message = "'org.eclipse.ui.views.properties.tabbed' is not found, but plugin activated";
        } else {
            String version = bundle.getVersion() == null ? "unknown" : bundle.getVersion().toString();
            message = "'org.eclipse.ui.views.properties.tabbed' has version " + version;
        }
        PropertiesViewPlugin.logErr(e, (String)message, new Object[0]);
    }

    public void recordEvent(Widget widget, int type, Event event) {
        if (!(widget instanceof TabbedPropertyList.ListElement)) {
            return;
        }
        if (type != 4) {
            return;
        }
        TabbedPropertyList.ListElement listElement = (TabbedPropertyList.ListElement)widget;
        FindResult r = this.getSWTRecorder().getLocator().findElement(widget, false, false, false);
        if (r == null) {
            return;
        }
        SWTUIElement parent = this.getSWTRecorder().getPlayer().getParentElement(r.realElement);
        if (!(parent instanceof WorkbenchUIElement)) {
            return;
        }
        WorkbenchUIElement workbenchUIElement = (WorkbenchUIElement)parent;
        IWorkbenchPartReference iWorkbenchPartReference = workbenchUIElement.getReference();
        if (!(iWorkbenchPartReference instanceof WorkbenchPartReference)) {
            return;
        }
        WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)iWorkbenchPartReference;
        Control control = workbenchPartReference.getPane().getControl();
        if (control == null || !(control instanceof Composite)) {
            return;
        }
        PartUIElement partUIElement = this.getSWTRecorder().getLocator().findPartElement(workbenchPartReference.getPart(true), false);
        partUIElement.propertyTab(listElement.getTabItem().getText()).click();
    }

    private SWTEventRecorder getSWTRecorder() {
        if (this.swtRecorder == null) {
            this.swtRecorder = (SWTEventRecorder)this.teslaRecorder.getProcessor(SWTEventRecorder.class);
        }
        return this.swtRecorder;
    }
}

