/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.rap;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.eclipse.pde.launching.EquinoxLaunchConfiguration;
import org.eclipse.rcptt.internal.launching.aut.LaunchInfoCache;
import org.eclipse.rcptt.internal.launching.ext.JDTUtils;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.internal.launching.ext.UpdateVMArgs;
import org.eclipse.rcptt.launching.events.AutEventManager;
import org.eclipse.rcptt.launching.ext.OriginalOrderProperties;
import org.eclipse.rcptt.launching.ext.Q7ExternalLaunchDelegate;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.ext.VmInstallMetaData;
import org.eclipse.rcptt.launching.internal.target.TargetPlatformHelper;
import org.eclipse.rcptt.launching.rap.Activator;
import org.eclipse.rcptt.launching.rap.BrowserLauncher;
import org.eclipse.rcptt.launching.rap.Q7RapLaunchMonitor;
import org.eclipse.rcptt.launching.rap.RAPLaunchConfig;
import org.eclipse.rcptt.launching.rap.URLBuilder;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.util.FileUtil;

public class RcpttRapLaunchDelegate
extends EquinoxLaunchConfiguration {
    private static final String OSGI_BUNDLES = "osgi.bundles";
    private static final String VMARG_PORT = "-Dorg.osgi.service.http.port=";
    private static final String VMARG_DEVELOPMENT_MODE = "-Dorg.eclipse.rap.rwt.developmentMode=";
    private static final String VMARG_SESSION_TIMEOUT = "-Dorg.eclipse.equinox.http.jetty.context.sessioninactiveinterval=";
    private static final String VMARG_CONTEXT_PATH = "-Dorg.eclipse.equinox.http.jetty.context.path=";
    private static final int CONNECT_TIMEOUT = 20000;
    static final String SLASH = "/";
    private BrowserLauncher browser;
    private ILaunch launch;
    private RAPLaunchConfig config;
    private int port;
    private final boolean testMode;
    private static final String ASPECTJ_BUNDLE = "org.eclipse.equinox.weaving.aspectj";
    private static final String SERVLETBRIDGE = "org.eclipse.equinox.servletbridge.extensionbundle";
    private static final String SECURE_STORAGE_FILE_NAME = "secure_storage";
    static final IStatus STATUS = new Status(1, "org.eclipse.rcptt.launching.rap", 601, "", null);
    private static final String ATTR_D32 = "-d32";

    public RcpttRapLaunchDelegate() {
        this.testMode = false;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor submonitor = this.doPreLaunch(configuration, launch, monitor);
        submonitor = SubMonitor.convert((IProgressMonitor)submonitor, (int)2000);
        Q7RapLaunchMonitor waiter = new Q7RapLaunchMonitor(launch);
        try {
            try {
                super.launch(configuration, mode, launch, (IProgressMonitor)submonitor.newChild(1000));
                waiter.wait((IProgressMonitor)submonitor.newChild(1000), TeslaLimits.getAUTStartupTimeout() / 1000, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (RcpttRapLaunchDelegate.this.config.getOpenBrowser()) {
                                RcpttRapLaunchDelegate.this.registerBrowserOpener();
                            }
                        }
                        catch (CoreException e) {
                            throw new RuntimeException("Browser not open");
                        }
                    }
                });
            }
            catch (CoreException e) {
                Activator.getDefault().errorLog("RCPTT: Failed to launch RAP AUT: " + configuration.getName(), e);
                waiter.handle((Exception)((Object)e));
                if (!e.getStatus().matches(8)) {
                    throw e;
                }
                waiter.dispose();
                submonitor.done();
                monitor.done();
            }
            catch (RuntimeException e) {
                Activator.getDefault().errorLog("RCPTT: Failed to launch RAP AUT: " + configuration.getName(), e);
                waiter.handle(e);
                throw e;
            }
        }
        finally {
            waiter.dispose();
            submonitor.done();
            monitor.done();
        }
    }

    protected void manageLaunch(ILaunch launch) {
    }

    public SubMonitor doPreLaunch(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.launch = launch;
        this.browser = new BrowserLauncher();
        this.config = new RAPLaunchConfig(config);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        this.terminateIfRunning((IProgressMonitor)subMonitor);
        subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        this.warnIfPortBusy(subMonitor);
        subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        this.port = this.determinePort((IProgressMonitor)subMonitor);
        return subMonitor;
    }

    protected void doPreLaunchCkeck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean autoValidate = configuration.getAttribute("automaticValidate", false);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(autoValidate ? 3 : 4));
        if (autoValidate) {
            this.validatePluginDependencies(configuration, (IProgressMonitor)subMonitor.split(1));
        }
        this.validateProjectDependencies(configuration, (IProgressMonitor)subMonitor.split(1));
        this.clear(configuration, (IProgressMonitor)subMonitor.split(1));
        launch.setAttribute("configLocation", this.getConfigDir(configuration).toString());
        this.synchronizeManifests(configuration, (IProgressMonitor)subMonitor.split(1));
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor subm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.doPreLaunchCkeck(configuration, launch, (IProgressMonitor)subm.newChild(50));
        if (monitor.isCanceled()) {
            return;
        }
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        ITargetPlatformHelper target = (ITargetPlatformHelper)info.target;
        Q7ExternalLaunchDelegate.BundlesToLaunch bundlesToLaunch = Q7ExternalLaunchDelegate.collectBundles((ITargetPlatformHelper)target, (IProgressMonitor)subm.newChild(50));
        Q7ExternalLaunchDelegate.setBundlesToLaunch((LaunchInfoCache.CachedInfo)info, (Q7ExternalLaunchDelegate.BundlesToLaunch)bundlesToLaunch);
        RcpttRapLaunchDelegate.setDelegateFields(this, bundlesToLaunch.fModels, Maps.transformValues((Map)bundlesToLaunch.fAllBundles.asMap(), ArrayList::new));
        this.copyConfiguratonFiles(configuration, info);
        monitor.done();
    }

    private void copyConfiguratonFiles(ILaunchConfiguration configuration, LaunchInfoCache.CachedInfo info) throws CoreException {
        File[] listFiles;
        String targetPlatformPath = ((ITargetPlatformHelper)info.target).getTargetPlatformProfilePath();
        File configFolder = new File(targetPlatformPath, "configuration");
        if (!configFolder.exists()) {
            return;
        }
        HashSet<String> filter = new HashSet<String>(Arrays.asList(new String(".p2;org.eclipse.core.runtime;org.eclipse.equinox.app;org.eclipse.equinox.simpleconfigurator;org.eclipse.equinox.source;org.eclipse.osgi;org.eclipse.ui.intro.universal;org.eclipse.update;config.ini;.settings;org.eclipse.help.base").split(";")));
        File target = this.getConfigDir(configuration);
        File[] fileArray = listFiles = configFolder.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!filter.contains(file.getName())) {
                if (file.isDirectory()) {
                    FileUtil.copyFiles((File)file, (File)new File(target, file.getName()));
                } else {
                    FileUtil.copyFiles((File)file, (File)target);
                }
            }
            ++n2;
        }
    }

    public static void setDelegateFields(EquinoxLaunchConfiguration delegate, Map<IPluginModelBase, String> models, Map<String, List<IPluginModelBase>> allBundles) throws CoreException {
        Exception ex;
        try {
            Field field = EquinoxLaunchConfiguration.class.getDeclaredField("fModels");
            field.setAccessible(true);
            field.set(delegate, models);
            field = EquinoxLaunchConfiguration.class.getDeclaredField("fAllBundles");
            field.setAccessible(true);
            field.set(delegate, allBundles);
            return;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (SecurityException e) {
            ex = e;
        }
        catch (NoSuchFieldException e) {
            ex = e;
        }
        throw new CoreException((IStatus)RcpttRapLaunchDelegate.createStatus("Failed to inject bundles", ex));
    }

    private static Status createStatus(String message, Throwable ex) {
        return new Status(4, "org.eclipse.rcptt.launching.rap", message, ex);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return false;
        }
        if (!super.preLaunchCheck(configuration, mode, monitor)) {
            return false;
        }
        this.waitForClearBundlePool(monitor);
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        if (info.target != null) {
            return true;
        }
        ITargetPlatformHelper target = Q7TargetPlatformManager.findTarget((ILaunchConfiguration)configuration, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)2));
        if (target == null) {
            throw new CoreException(Status.error((String)("AUT " + configuration.getName() + " has lost its target platfom. Edit the AUT to restore it.")));
        }
        if (monitor.isCanceled()) {
            this.removeTargetPlatform(configuration);
            return false;
        }
        info.target = target;
        MultiStatus error = new MultiStatus("org.eclipse.rcptt.launching.ext", 0, "Target platform initialization failed  for " + configuration.getName(), null);
        error.add(target.getStatus());
        if (!error.isOK()) {
            if (monitor.isCanceled()) {
                this.removeTargetPlatform(configuration);
                return false;
            }
            Q7ExtLaunchingPlugin.log((IStatus)error);
            this.removeTargetPlatform(configuration);
            throw new CoreException((IStatus)error);
        }
        boolean haveAUT = false;
        OSArchitecture configArch = null;
        StringBuilder detectMsg = new StringBuilder();
        OSArchitecture architecture = configArch == null ? ((ITargetPlatformHelper)info.target).detectArchitecture(detectMsg) : configArch;
        IVMInstall install = VMHelper.getVMInstall((ILaunchConfiguration)configuration);
        OSArchitecture jvmArch = JDTUtils.detect((IVMInstall)install);
        if (jvmArch.equals((Object)architecture)) {
            haveAUT = true;
        }
        if (!haveAUT && architecture != OSArchitecture.Unknown && target.detectArchitecture(new StringBuilder()) == OSArchitecture.Unknown) {
            haveAUT = true;
        }
        if (!haveAUT) {
            haveAUT = RcpttRapLaunchDelegate.updateJVM(configuration, architecture, (ITargetPlatformHelper)info.target);
        }
        if (!haveAUT) {
            this.removeTargetPlatform(configuration);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.rap", "", null));
        }
        return true;
    }

    private void waitForClearBundlePool(IProgressMonitor monitor) {
        try {
            Job.getJobManager().join((Object)"q7.clean.bundle.pool.job", (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeTargetPlatform(ILaunchConfiguration configuration) throws CoreException {
        Q7TargetPlatformManager.delete((ILaunchConfiguration)configuration);
        LaunchInfoCache.remove((ILaunchConfiguration)configuration);
    }

    public String[] getVMArguments(ILaunchConfiguration config) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)config);
        if (info.vmArgs != null) {
            return info.vmArgs;
        }
        List<CallSite> args = new ArrayList<Object>();
        args.add((CallSite)((Object)"-Declipse.ignoreApp=true"));
        args.add((CallSite)((Object)"-Dosgi.noShutdown=true"));
        args.addAll(Arrays.asList(super.getVMArguments(config)));
        args.addAll(this.getRAPVMArguments());
        Iterables.removeIf(args, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.contains("-Declipse.pde.launch=true");
            }
        });
        args.add((CallSite)((Object)("-Dq7id=" + this.launch.getAttribute("org.eclipse.rcptt.launching.ATTR_AUT_LAUNCH_ID"))));
        args.add((CallSite)((Object)("-Dq7EclPort=" + AutEventManager.INSTANCE.getPort())));
        TargetPlatformHelper target = (TargetPlatformHelper)((ITargetPlatformHelper)info.target);
        IPluginModelBase hook = target.getWeavingHook();
        if (hook == null) {
            throw new CoreException(Q7ExtLaunchingPlugin.status((String)"No org.eclipse.equinox.weaving.hook plugin"));
        }
        OriginalOrderProperties properties = target.getConfigIniProperties();
        args = UpdateVMArgs.addHook(args, (IPluginModelBase)hook, (String)properties.getProperty("osgi.framework.extensions"));
        args.add((CallSite)((Object)("-Declipse.vmargs=" + Joiner.on((String)"\n").join(args) + "\n")));
        info.vmArgs = args.toArray(new String[args.size()]);
        return info.vmArgs;
    }

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        ITargetPlatformHelper target = (ITargetPlatformHelper)info.target;
        if (info.programArgs != null) {
            return info.programArgs;
        }
        ArrayList<Object> programArguments = new ArrayList<Object>();
        programArguments.addAll(Arrays.asList(super.getProgramArguments(configuration)));
        String dataLocationResolved = this.getResolvedDataLoacation();
        if (dataLocationResolved.length() > 0) {
            programArguments.addAll(Arrays.asList("-data", dataLocationResolved));
        }
        try {
            File config = new File(this.getConfigDir(configuration), "config.ini");
            Properties props = this.readProperty(config);
            File location = target.getQ7Target().getInstallLocation();
            if (location != null) {
                props.setProperty("osgi.install.area", location.getAbsolutePath());
            }
            OriginalOrderProperties properties = target.getConfigIniProperties();
            String property = properties.getProperty(OSGI_BUNDLES);
            boolean autostart = configuration.getAttribute("default_auto_start", true);
            props.setProperty(OSGI_BUNDLES, RcpttRapLaunchDelegate.computeOSGiBundles(info, autostart, property));
            properties.setBeginAdd(true);
            properties.putAll((Map)props);
            this.writeProperty(config, properties);
        }
        catch (IOException e) {
            throw new CoreException(Q7ExtLaunchingPlugin.status((Throwable)e));
        }
        if (configuration.getAttribute("override-secure-storage", true)) {
            programArguments.add("-eclipse.keyring");
            programArguments.add(this.getConfigDir(configuration).toString() + "/secure_storage");
        }
        IVMInstall install = VMHelper.getVMInstall((ILaunchConfiguration)configuration);
        programArguments.add("-vm");
        programArguments.add(install.getInstallLocation().toString());
        info.programArgs = programArguments.toArray(new String[programArguments.size()]);
        return info.programArgs;
    }

    public static Map<IPluginModelBase, String> getTargetBundleMap(String bundles) throws CoreException {
        HashMap<IPluginModelBase, String> map = new HashMap<IPluginModelBase, String>();
        StringTokenizer tok = new StringTokenizer(bundles, ",");
        while (tok.hasMoreTokens()) {
            IPluginModelBase[] models;
            String idVersion;
            int versionIndex;
            String token = tok.nextToken();
            int index = token.indexOf(64);
            if (index < 0) {
                token = token.concat("@default:default");
                index = token.indexOf(64);
            }
            String id = (versionIndex = (idVersion = token.substring(0, index)).indexOf(42)) > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            String version = versionIndex > 0 ? idVersion.substring(versionIndex + 1) : null;
            ModelEntry entry = PluginRegistry.findEntry((String)id);
            if (entry == null) continue;
            IPluginModelBase[] iPluginModelBaseArray = models = entry.getExternalModels();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginBase base;
                IPluginModelBase model = iPluginModelBaseArray[n2];
                if (model.isEnabled() && ((base = model.getPluginBase()).getVersion().equals(version) || version == null || models.length == 1)) {
                    RcpttRapLaunchDelegate.addBundleToMap(map, model, token.substring(index + 1));
                }
                ++n2;
            }
        }
        return map;
    }

    private static void addBundleToMap(Map<IPluginModelBase, String> map, IPluginModelBase bundle, String sl) {
        boolean defaultsl;
        BundleDescription desc = bundle.getBundleDescription();
        boolean bl = defaultsl = sl == null || sl.equals("default:default");
        if (desc != null && defaultsl) {
            String runLevelText = BundleLauncherHelper.resolveSystemRunLevelText((BundleDescription)desc);
            String autoText = BundleLauncherHelper.resolveSystemAutoText((BundleDescription)desc);
            if (runLevelText != null && autoText != null) {
                map.put(bundle, runLevelText + ":" + autoText);
            } else {
                map.put(bundle, sl);
            }
        } else {
            map.put(bundle, sl);
        }
    }

    private static String computeOSGiBundles(LaunchInfoCache.CachedInfo info, boolean autostart, String defaultBundles) throws CoreException {
        Map lastversion = RcpttRapLaunchDelegate.getBundlesToLaunch((LaunchInfoCache.CachedInfo)info).latestVersionsOnly;
        LinkedHashMap<String, IPluginModelBase> bundles = new LinkedHashMap<String, IPluginModelBase>(lastversion.size());
        Set models = lastversion.keySet();
        for (IPluginModelBase model : models) {
            bundles.put(model.getPluginBase().getId(), model);
        }
        if (bundles.containsKey("org.eclipse.equinox.simpleconfigurator")) {
            return Q7LaunchDelegateUtils.computeOSGiBundles((Map)lastversion);
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iter = models.iterator();
        Map<IPluginModelBase, String> defaultModels = RcpttRapLaunchDelegate.getTargetBundleMap(defaultBundles);
        while (iter.hasNext()) {
            String startData;
            IPluginModelBase model = (IPluginModelBase)iter.next();
            String id = model.getPluginBase().getId();
            if ("org.eclipse.osgi".equals(id)) continue;
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(LaunchConfigurationHelper.getBundleURL((IPluginModelBase)model, (boolean)true));
            if (model instanceof IFragmentModel || (startData = RcpttRapLaunchDelegate.getStartData(model, defaultModels)) == null) continue;
            RcpttRapLaunchDelegate.appendStartData(buffer, startData, autostart);
        }
        return buffer.toString();
    }

    private static String getStartData(IPluginModelBase model, Map<IPluginModelBase, String> defaultModels) {
        String id = model.getBundleDescription().getName();
        if (SERVLETBRIDGE.equals(id)) {
            return null;
        }
        if ("org.apache.felix.scr".equals(id)) {
            return "1:true";
        }
        if (ASPECTJ_BUNDLE.equals(id)) {
            return "1:true";
        }
        if (defaultModels.containsKey(model)) {
            return defaultModels.get(model);
        }
        return "default:default";
    }

    private static void appendStartData(StringBuffer buffer, String startData, boolean defaultAuto) {
        String auto;
        int index = startData.indexOf(58);
        String level = index > 0 ? startData.substring(0, index) : "default";
        String string = auto = index > 0 && index < startData.length() - 1 ? startData.substring(index + 1) : "default";
        if ("default".equals(auto)) {
            auto = Boolean.toString(defaultAuto);
        }
        if (!level.equals("default") || "true".equals(auto)) {
            buffer.append("@");
        }
        if (!level.equals("default")) {
            buffer.append(level);
            if ("true".equals(auto)) {
                buffer.append(":");
            }
        }
        if ("true".equals(auto)) {
            buffer.append("start");
        }
    }

    private void writeProperty(File config, OriginalOrderProperties properties) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(config));){
            properties.store((OutputStream)out, "Configuration File");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Properties readProperty(File config) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(config));){
            props.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return props;
    }

    public static Q7ExternalLaunchDelegate.BundlesToLaunch getBundlesToLaunch(LaunchInfoCache.CachedInfo info) {
        return (Q7ExternalLaunchDelegate.BundlesToLaunch)info.data.get("bundlesToLaunch");
    }

    private String getResolvedDataLoacation() throws CoreException {
        String dataLocation = this.config.getDataLocation();
        return this.resolveVariables(dataLocation);
    }

    private String resolveVariables(String dataLocation) throws CoreException {
        VariablesPlugin variablePlugin = VariablesPlugin.getDefault();
        IStringVariableManager stringVariableManager = variablePlugin.getStringVariableManager();
        return stringVariableManager.performStringSubstitution(dataLocation);
    }

    private List<String> getRAPVMArguments() throws CoreException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(VMARG_PORT + this.port);
        arguments.add(VMARG_DEVELOPMENT_MODE + this.config.getDevelopmentMode());
        if (this.config.getUseSessionTimeout()) {
            arguments.add(VMARG_SESSION_TIMEOUT + this.config.getSessionTimeout());
        } else {
            arguments.add("-Dorg.eclipse.equinox.http.jetty.context.sessioninactiveinterval=0");
        }
        if (this.config.getUseManualContextPath()) {
            Object contextPath = this.config.getContextPath();
            if (!((String)contextPath).startsWith(SLASH)) {
                contextPath = SLASH + (String)contextPath;
            }
            if (((String)contextPath).endsWith(SLASH)) {
                contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
            }
            arguments.add(VMARG_CONTEXT_PATH + (String)contextPath);
        }
        return arguments;
    }

    private void warnIfPortBusy(SubMonitor monitor) throws CoreException {
        monitor.beginTask("Checking manual port", -1);
        try {
            IStatus status;
            Object resolution;
            DebugPlugin debugPlugin;
            IStatusHandler prompter;
            if (this.config.getUseManualPort() && RcpttRapLaunchDelegate.isPortBusy(this.config.getPort()) && (prompter = (debugPlugin = DebugPlugin.getDefault()).getStatusHandler(promptStatus)) != null && Boolean.FALSE.equals(resolution = prompter.handleStatus(status = STATUS, (Object)this.config))) {
                String text = "Port {0,number,\\#} in use. Launch ''{1}'' interrupted by user.";
                Object[] args = new Object[]{this.config.getPort(), this.config.getName()};
                String msg = MessageFormat.format(text, args);
                String pluginId = "org.eclipse.rcptt.launching.rap";
                Status infoStatus = new Status(1, pluginId, msg);
                throw new CoreException((IStatus)infoStatus);
            }
        }
        finally {
            monitor.done();
        }
    }

    private int determinePort(IProgressMonitor monitor) throws CoreException {
        int result;
        monitor.beginTask("Determining port number", -1);
        try {
            result = this.config.getUseManualPort() ? this.config.getPort() : RcpttRapLaunchDelegate.findFreePort();
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private static int findFreePort() throws CoreException {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (ServerSocket server = new ServerSocket(0);){
                return server.getLocalPort();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String msg = "Could not obtain a free port number.";
            String pluginId = "org.eclipse.rcptt.launching.rap";
            Status status = new Status(4, pluginId, msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPortBusy(int port) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                ServerSocket server = new ServerSocket(port);
                if (server == null) return false;
                server.close();
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return true;
        }
    }

    private URL getUrl() throws CoreException {
        try {
            String url = URLBuilder.fromLaunchConfig(this.config, this.port, this.testMode);
            return new URL(url);
        }
        catch (MalformedURLException e) {
            String msg = "Invalid URL.";
            String pluginId = "org.eclipse.rcptt.launching.rap";
            Status status = new Status(4, pluginId, 0, msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void terminateIfRunning(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Terminating previous launch", -1);
        try {
            ILaunch runningLaunch = this.findRunning();
            if (runningLaunch != null) {
                RcpttRapLaunchDelegate.terminate(runningLaunch);
            }
        }
        finally {
            monitor.done();
        }
    }

    private ILaunch findRunning() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] runningLaunches = launchManager.getLaunches();
        ILaunch result = null;
        int i = 0;
        while (result == null && i < runningLaunches.length) {
            ILaunch runningLaunch = runningLaunches[i];
            if (runningLaunch != this.launch && this.config.getName().equals(RcpttRapLaunchDelegate.getLaunchName(runningLaunch)) && !runningLaunch.isTerminated()) {
                result = runningLaunches[i];
            }
            ++i;
        }
        return result;
    }

    private static String getLaunchName(ILaunch launch) {
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        return launchConfiguration == null ? null : launchConfiguration.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void terminate(final ILaunch previousLaunch) throws DebugException {
        final Object signal = new Object();
        final boolean[] terminated = new boolean[1];
        final DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.addDebugEventListener(new IDebugEventSetListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleDebugEvents(DebugEvent[] events) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    if (RcpttRapLaunchDelegate.isTerminateEventFor(event, previousLaunch)) {
                        debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
                        Object object = signal;
                        synchronized (object) {
                            terminated[0] = true;
                            signal.notifyAll();
                        }
                    }
                    ++n2;
                }
            }
        });
        previousLaunch.terminate();
        try {
            Object object = signal;
            synchronized (object) {
                if (!terminated[0]) {
                    signal.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static boolean isTerminateEventFor(DebugEvent event, ILaunch launch) {
        boolean result = false;
        if (event.getKind() == 8 && event.getSource() instanceof RuntimeProcess) {
            RuntimeProcess process = (RuntimeProcess)event.getSource();
            result = process.getLaunch() == launch;
        }
        return result;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForHttpService(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        subMonitor.beginTask("Waiting for HTTP service", -1);
        try {
            block18: {
                boolean interrupted;
                boolean canConnect;
                long start;
                block17: {
                    start = System.currentTimeMillis();
                    canConnect = false;
                    interrupted = false;
                    if (!true) break block17;
                    if (System.currentTimeMillis() - start > 20000L) return;
                    if (canConnect) return;
                    if (interrupted) return;
                    if (monitor.isCanceled()) return;
                    if (this.launch.isTerminated()) break block18;
                }
                do {
                    try {
                        Throwable throwable = null;
                        Object var8_9 = null;
                        try (Socket socket = new Socket(URLBuilder.getHost(), this.port);){
                            canConnect = true;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                                throw throwable;
                            }
                            if (throwable == throwable2) throw throwable;
                            throwable.addSuppressed(throwable2);
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                    }
                    if (System.currentTimeMillis() - start > 20000L) return;
                    if (canConnect) return;
                    if (interrupted) return;
                    if (monitor.isCanceled()) return;
                } while (!this.launch.isTerminated());
            }
            return;
        }
        finally {
            subMonitor.done();
        }
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (RcpttRapLaunchDelegate.isHeadless(configuration)) {
            return true;
        }
        return super.saveBeforeLaunch(configuration, mode, monitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (RcpttRapLaunchDelegate.isHeadless(configuration)) {
            return true;
        }
        return super.finalLaunchCheck(configuration, mode, monitor);
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = this.constructClasspath(configuration);
        if (classpath == null) {
            String message = PDEMessages.WorkbenchLauncherConfigurationDelegate_noStartup;
            throw new CoreException((IStatus)RcpttRapLaunchDelegate.createStatus(message, null));
        }
        return classpath;
    }

    private String[] constructClasspath(ILaunchConfiguration configuration) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        ITargetPlatformHelper target = (ITargetPlatformHelper)info.target;
        String jarPath = target.getEquinoxStartupPath("org.eclipse.equinox.launcher");
        if (jarPath == null) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(jarPath);
        String bootstrap = configuration.getAttribute("bootstrap", "");
        StringTokenizer tok = new StringTokenizer(RcpttRapLaunchDelegate.getSubstitutedString(bootstrap), ",");
        while (tok.hasMoreTokens()) {
            entries.add(tok.nextToken().trim());
        }
        return entries.toArray(new String[entries.size()]);
    }

    private static String getSubstitutedString(String text) throws CoreException {
        if (text == null) {
            return "";
        }
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        return mgr.performStringSubstitution(text);
    }

    public void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        this.clearDataLocation(configuration, monitor);
        super.clear(configuration, monitor);
    }

    private static boolean isHeadless(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("q7.headless.launch", false);
    }

    private void clearDataLocation(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String resolvedDataLocation = this.getResolvedDataLoacation();
        LauncherUtils.clearWorkspace((ILaunchConfiguration)configuration, (String)resolvedDataLocation, (String)this.launch.getLaunchMode(), (IProgressMonitor)monitor);
    }

    private void registerBrowserOpener() {
        String jobTaskName = "Starting client application";
        Job job = new Job("Starting client application"){

            protected IStatus run(IProgressMonitor monitor) {
                String taskName = "Starting client application";
                monitor.beginTask(taskName, 2);
                try {
                    RcpttRapLaunchDelegate.this.waitForHttpService(monitor);
                    monitor.worked(1);
                    if (!RcpttRapLaunchDelegate.this.launch.isTerminated()) {
                        RcpttRapLaunchDelegate.this.openBrowser(monitor);
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void openBrowser(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        subMonitor.beginTask("Starting client application", -1);
        try {
            URL url = null;
            try {
                url = this.getUrl();
                this.browser.launch(url, this.config);
            }
            catch (CoreException e) {
                String msg = MessageFormat.format("Failed to open browser for URL ''{0}''.", url);
                Activator.getDefault().errorLog(msg, e);
            }
        }
        finally {
            subMonitor.done();
        }
    }

    private static boolean updateJVM(ILaunchConfiguration configuration, OSArchitecture architecture, ITargetPlatformHelper target) throws CoreException {
        OSArchitecture autArch;
        OSArchitecture jvmArch = OSArchitecture.Unknown;
        IVMInstall jvmInstall = VmInstallMetaData.all().filter(m -> m.arch.equals((Object)architecture)).findFirst().map(i -> i.install).orElse(null);
        if (jvmInstall == null) {
            return false;
        }
        ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
        Object vmArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, Q7LaunchDelegateUtils.getJoinedVMArgs((ITargetPlatformHelper)target, null));
        String archAttrValue = configuration.getAttribute("com.xored.launching.common.attrArch", "");
        OSArchitecture configArch = archAttrValue.isEmpty() ? null : OSArchitecture.valueOf((String)archAttrValue);
        OSArchitecture oSArchitecture = autArch = configArch == null ? target.detectArchitecture(null) : configArch;
        if (!autArch.equals((Object)jvmArch) && Platform.getOS().equals("macosx")) {
            vmArgs = vmArgs != null && !((String)vmArgs).contains(ATTR_D32) ? (String)vmArgs + " -d32" : ATTR_D32;
        }
        if (vmArgs != null && ((String)vmArgs).length() > 0) {
            vmArgs = UpdateVMArgs.updateAttr((String)vmArgs);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, (String)vmArgs);
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, String.format("org.eclipse.jdt.launching.JRE_CONTAINER/%s/%s", jvmInstall.getVMInstallType().getId(), jvmInstall.getName()));
        Object programArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, LaunchArgumentsHelper.getInitialProgramArguments().trim());
        if (((String)programArgs).contains("${target.arch}")) {
            programArgs = ((String)programArgs).replace("${target.arch}", autArch.name());
        } else if (((String)programArgs).contains("-arch")) {
            int pos = ((String)programArgs).indexOf("-arch ") + 6;
            int len = 6;
            int pos2 = ((String)programArgs).indexOf("x86_64", pos);
            if (pos2 == -1) {
                len = 3;
                pos2 = ((String)programArgs).indexOf("x86", pos);
            }
            if (pos2 != -1) {
                programArgs = ((String)programArgs).substring(0, pos) + autArch.name() + ((String)programArgs).substring(pos2 + len, ((String)programArgs).length());
            }
        } else {
            programArgs = (String)programArgs + " -arch " + autArch.name();
        }
        if (((String)programArgs).length() > 0) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, (String)programArgs);
        }
        workingCopy.doSave();
        return true;
    }
}

