/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rcptt.core.builder.IQ7ProblemReporter;
import org.eclipse.rcptt.core.builder.IQ7Validator;
import org.eclipse.rcptt.core.internal.builder.Q7BuilderActivator;
import org.eclipse.rcptt.core.internal.builder.Q7ProblemCollector;
import org.eclipse.rcptt.core.internal.builder.Q7ValidatorManager;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementDelta;
import org.eclipse.rcptt.core.model.IQ7ElementVisitor;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.utils.ModelCycleDetector;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.WorkspaceMonitor;
import org.eclipse.rcptt.internal.core.model.BackReferencesProjectScope;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.core.model.deltas.Q7ElementDelta;
import org.eclipse.rcptt.internal.core.model.index.NamedElementCollector;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Q7Builder
extends IncrementalProjectBuilder {
    private static final String MSG_Q7_Builder = "RCP Testing Tool: Checking model consistency";
    private static boolean isEnable = true;
    private static List<Runnable> listeners = new ArrayList<Runnable>();
    private static final ILog LOG = Platform.getLog((Bundle)FrameworkUtil.getBundle(Q7Builder.class));
    public static final String BUILDER_ID = "org.eclipse.rcptt.core.builder.q7Builder";
    public static final String MARKER_TYPE = "org.eclipse.rcptt.core.builder.q7Problem";
    private static final int NTHREDS = 10;
    private Q7ValidatorManager validatorMgr;
    public static boolean debug_sleep = false;

    public static synchronized void addListener(Runnable runnable) {
        listeners.add(runnable);
    }

    public static synchronized void removeListener(Runnable runnable) {
        listeners.remove(runnable);
    }

    public static IMarker addMarker(IFile file, String message, int lineNumber, int severity, int offset, int length, int sourceId) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            if (sourceId > 0) {
                marker.setAttribute("sourceId", sourceId);
            }
            marker.setAttribute("lineNumber", lineNumber);
            if (offset >= 0 && length > 0) {
                marker.setAttribute("charStart", offset);
                marker.setAttribute("charEnd", offset + length);
            }
            return marker;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static void setEnabled(boolean isEnable) {
        Q7Builder.isEnable = isEnable;
    }

    static void log(IStatus status) {
        block5: {
            try {
                Q7BuilderActivator pl = Q7BuilderActivator.getDefault();
                if (pl != null && pl.getLog() != null) {
                    pl.getLog().log(status);
                } else if (status.getException() != null) {
                    status.getException().printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (status.getException() == null) break block5;
                status.getException().printStackTrace();
            }
        }
    }

    static void log(Throwable e) {
        Q7Builder.log((IStatus)new Status(4, "org.eclipse.rcptt.core.builder", 75, "Internal error in RCP Testing Tool Builder", e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        block21: {
            if (!isEnable) {
                return null;
            }
            ModelManager.getModelManager().projectStartBuilding(this.getProject());
            try {
                try {
                    while (debug_sleep) {
                        Thread.sleep(50L);
                    }
                    ModelManager.getModelManager().getIndexManager().waitUntilReady((IProgressMonitor)new NullProgressMonitor());
                    this.getQ7Project().getMetadata();
                    if (kind == 6) {
                        this.fullBuild(monitor);
                    } else {
                        IResourceDelta delta = this.getDelta(this.getProject());
                        if (delta == null) {
                            this.fullBuild(monitor);
                        } else {
                            try {
                                this.incrementalBuild(delta, monitor);
                            }
                            catch (CoreException e) {
                                Q7Builder.log(e);
                                this.fullBuild(monitor);
                            }
                        }
                    }
                    break block21;
                }
                catch (InterruptedException e) {
                    throw new CoreException(Q7Builder.error(e));
                }
                catch (RuntimeException e) {
                    throw new CoreException(Q7Builder.error(e));
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                ModelManager.getModelManager().projectStopBuilding(this.getProject());
                Q7Builder q7Builder = this;
                synchronized (q7Builder) {
                    for (Runnable listener : listeners) {
                        listener.run();
                    }
                }
            }
            throw throwable;
        }
        monitor.done();
        ModelManager.getModelManager().projectStopBuilding(this.getProject());
        Q7Builder q7Builder = this;
        synchronized (q7Builder) {
            for (Runnable listener : listeners) {
                listener.run();
            }
        }
        return null;
    }

    private static boolean addResource(IResource resource, List<IQ7NamedElement> elements) {
        if (resource instanceof IFile && RcpttCore.isQ7File((IPath)resource.getFullPath()) && !WorkspaceMonitor.isIgnored((IResource)resource)) {
            IFile file = (IFile)resource;
            Q7Builder.deleteMarkers(file);
            elements.add((IQ7NamedElement)RcpttCore.create((IResource)file));
        }
        return true;
    }

    private static void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void fullBuild(final IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            IContext[] contexts;
            monitor.beginTask(MSG_Q7_Builder, 100);
            NamedElementCollector collector = new NamedElementCollector(){

                public boolean visit(IQ7Element element) {
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    return super.visit(element);
                }
            };
            IQ7Project project = this.getQ7Project();
            project.accept((IQ7ElementVisitor)collector);
            monitor.worked(10);
            List elements = collector.getElements();
            IContext[] iContextArray = contexts = Q7SearchCore.findAllContexts();
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IContext c = iContextArray[n2];
                elements.add(c);
                ++n2;
            }
            this.buildElements(elements, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
            monitor.done();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private IQ7Project getQ7Project() {
        return RcpttCore.create((IProject)this.getProject());
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IResourceDelta[] affectedChildren;
        monitor.beginTask(MSG_Q7_Builder, 40);
        boolean needFullBuildProjectMetadataChange = false;
        IResourceDelta[] iResourceDeltaArray = affectedChildren = delta.getAffectedChildren();
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta res = iResourceDeltaArray[n2];
            if (RcpttCore.isQ7ProjectMetadata((IPath)res.getFullPath())) {
                needFullBuildProjectMetadataChange = true;
                break;
            }
            ++n2;
        }
        if ((needFullBuildProjectMetadataChange || (delta.getFlags() & 0x80000) != 0) && delta.getResource() instanceof IProject) {
            this.fullBuild(monitor);
            return;
        }
        List<IQ7NamedElement> elements = new ArrayList<IQ7NamedElement>();
        Q7DeltaVisitor visitor = new Q7DeltaVisitor(elements);
        delta.accept((IResourceDeltaVisitor)visitor);
        List<IPath> removed = visitor.getRemoved();
        Set<IPath> changedResources = visitor.getChangedResources();
        long start = System.currentTimeMillis();
        elements = this.calculateExtraDependencies(elements, removed, changedResources, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        this.buildElements(elements, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
        monitor.done();
    }

    private void buildElements(List<IQ7NamedElement> elements, final IProgressMonitor monitor) {
        try {
            final Q7ProblemCollector collector = new Q7ProblemCollector();
            final IQ7Validator[] validators = this.getValidators();
            monitor.beginTask("Validate RCPTT model:", elements.size() + 20);
            ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
            for (final IQ7NamedElement element : elements) {
                if (monitor.isCanceled()) {
                    monitor.done();
                    return;
                }
                executor.execute(new Runnable(){

                    /*
                     * Exception decompiling
                     */
                    @Override
                    public void run() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[WHILELOOP]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                });
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
                try {
                    Thread.sleep(50L);
                }
                catch (Throwable element) {
                    // empty catch block
                }
            }
            ModelCycleDetector.CycleGraph graph = ModelCycleDetector.buildCycles((IQ7NamedElement[])elements.toArray(new IQ7NamedElement[elements.size()]), null, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            if (graph.cycle) {
                Set set = graph.graph.keySet();
                for (String id : set) {
                    if (monitor.isCanceled()) {
                        monitor.done();
                        return;
                    }
                    IQ7NamedElement element = (IQ7NamedElement)graph.elementsMap.get(id);
                    if (element == null) continue;
                    List toElementID = (List)graph.graph.get(id);
                    StringBuilder names = new StringBuilder();
                    for (String eid : toElementID) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        IQ7NamedElement toElement = (IQ7NamedElement)graph.elementsMap.get(eid);
                        if (toElement != null) {
                            if (names.length() > 0) {
                                names.append(", ");
                            }
                            names.append(toElement.getName());
                            continue;
                        }
                        names.append(eid);
                    }
                    collector.reportProblem((IFile)element.getResource(), IQ7ProblemReporter.ProblemType.Error, "Circular reference to context('s) " + names.toString() + " is detected", -1, -1, -1, -1);
                }
            }
            collector.flushProblems(new SubProgressMonitor(monitor, 10));
            ModelManager mm = ModelManager.getModelManager();
            Q7ElementDelta delta = new Q7ElementDelta((IQ7Element)mm.getModel());
            for (IQ7NamedElement el : elements) {
                delta.changed((IQ7Element)el, 131072);
            }
            mm.getDeltaProcessor().fire((IQ7ElementDelta)delta, 1);
        }
        finally {
            monitor.done();
        }
    }

    private IQ7Validator[] getValidators() {
        if (this.validatorMgr == null) {
            this.validatorMgr = new Q7ValidatorManager();
        }
        return this.validatorMgr.getExtensions();
    }

    /*
     * WARNING - void declaration
     */
    private List<IQ7NamedElement> calculateExtraDependencies(List<IQ7NamedElement> elements, List<IPath> removed, Set<IPath> changedResources, IProgressMonitor monitor) throws CoreException {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(elements);
        while (!monitor.isCanceled()) {
            int cur = result.size();
            ArrayList<Object> temp = new ArrayList<Object>();
            temp.addAll(result);
            for (IQ7NamedElement iQ7NamedElement : temp) {
                IQ7NamedElement[] usage;
                String id;
                if (monitor.isCanceled()) break;
                if (iQ7NamedElement instanceof IContext) {
                    try {
                        id = Q7SearchCore.findIDByDocument((IQ7Element)iQ7NamedElement);
                        if (id == null) {
                            id = iQ7NamedElement.getID();
                        }
                        usage = Q7SearchCore.findContextUsage((String)id, (ISearchScope)new BackReferencesProjectScope(this.getQ7Project()), (IProgressMonitor)monitor);
                        result.addAll(Arrays.asList(usage));
                    }
                    catch (ModelException e) {
                        RcpttPlugin.log((Throwable)e);
                    }
                }
                if (iQ7NamedElement instanceof IVerification) {
                    try {
                        id = Q7SearchCore.findIDByDocument((IQ7Element)iQ7NamedElement);
                        if (id == null) {
                            id = iQ7NamedElement.getID();
                        }
                        usage = Q7SearchCore.findVerificationUsage((String)id, (ISearchScope)new BackReferencesProjectScope(this.getQ7Project()), (IProgressMonitor)monitor);
                        result.addAll(Arrays.asList(usage));
                    }
                    catch (ModelException e) {
                        RcpttPlugin.log((Throwable)e);
                    }
                }
                try {
                    IQ7NamedElement[] sameID = Q7SearchCore.findById((String)iQ7NamedElement.getID(), (ISearchScope)new BackReferencesProjectScope(iQ7NamedElement.getQ7Project()), (IProgressMonitor)monitor);
                    if (sameID == null) continue;
                    result.addAll(Arrays.asList(sameID));
                }
                catch (ModelException e) {
                    RcpttPlugin.log((Throwable)e);
                }
            }
            if (removed != null && removed.size() > 0) {
                result.addAll(Arrays.asList(Q7SearchCore.findElementsWithUnusedReferences((ISearchScope)new ReferencedProjectScope(this.getQ7Project()), (IProgressMonitor)monitor)));
                result.addAll(this.findMarkedElements());
                result.addAll(Arrays.asList(Q7SearchCore.findAllTestSuites((ISearchScope)new ReferencedProjectScope(this.getQ7Project()))));
            }
            if (cur != result.size()) continue;
        }
        if (changedResources != null && changedResources.size() > 0) {
            void var8_11;
            IContext[] contexts;
            IContext[] iContextArray = contexts = Q7SearchCore.findContextsWithLinks((ISearchScope)new BackReferencesProjectScope(this.getQ7Project()), changedResources, (IProgressMonitor)monitor);
            int n = contexts.length;
            boolean n2 = false;
            while (var8_11 < n) {
                IContext c = iContextArray[var8_11];
                result.add(c);
                ++var8_11;
            }
        }
        monitor.done();
        return new ArrayList<IQ7NamedElement>(result);
    }

    Collection<IQ7NamedElement> findMarkedElements() throws CoreException {
        ArrayList<IQ7NamedElement> rv = new ArrayList<IQ7NamedElement>();
        IMarker[] iMarkerArray = this.getProject().findMarkers(MARKER_TYPE, true, 2);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            IResource resource = marker.getResource();
            if (resource instanceof IFile && RcpttCore.isQ7File((IPath)resource.getFullPath())) {
                rv.add((IQ7NamedElement)RcpttCore.create((IResource)resource));
            }
            ++n2;
        }
        return rv;
    }

    private static IStatus error(InterruptedException e) {
        return new Status(8, LOG.getBundle().getSymbolicName(), 0, "Interrupted", (Throwable)e);
    }

    private static IStatus error(Exception e) {
        return new Status(8, LOG.getBundle().getSymbolicName(), 0, e.getLocalizedMessage(), (Throwable)e);
    }

    static /* synthetic */ void access$1(IFile iFile) {
        Q7Builder.deleteMarkers(iFile);
    }

    class Q7DeltaVisitor
    implements IResourceDeltaVisitor {
        private List<IQ7NamedElement> elements;
        private List<IPath> removed = new ArrayList<IPath>();
        private Set<IPath> changedResources = new HashSet<IPath>();

        public Q7DeltaVisitor(List<IQ7NamedElement> elements) {
            this.elements = elements;
        }

        public List<IPath> getRemoved() {
            return this.removed;
        }

        public Set<IPath> getChangedResources() {
            return this.changedResources;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    Q7Builder.addResource(resource, this.elements);
                    break;
                }
                case 2: {
                    this.removed.add(resource.getFullPath());
                    break;
                }
                case 4: {
                    Q7Builder.addResource(resource, this.elements);
                }
            }
            IResourceDelta[] affectedChildren = delta.getAffectedChildren();
            if (affectedChildren.length == 0) {
                this.changedResources.add(resource.getFullPath());
            }
            return true;
        }
    }
}

