/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdi.internal.PrimitiveTypeImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.CompoundInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.RuntimeSignature;
import org.eclipse.osgi.util.NLS;

public class LocalVariableCreation
extends CompoundInstruction {
    private final boolean fIsPrimitiveType;
    private final String fName;
    private final String fTypeSignature;
    private final int fDimension;
    private final boolean fHasInitializer;

    public LocalVariableCreation(String name, String typeSignature, int dimension, boolean isPrimitiveType, boolean hasInitializer, int start) {
        super(start);
        this.fName = name;
        this.fTypeSignature = typeSignature.replace('/', '.');
        this.fIsPrimitiveType = isPrimitiveType;
        this.fHasInitializer = hasInitializer;
        this.fDimension = dimension;
    }

    @Override
    public void execute() throws CoreException {
        IJavaType type;
        if (this.fIsPrimitiveType) {
            JDIDebugTarget debugTarget = (JDIDebugTarget)this.getVM();
            VirtualMachine vm = debugTarget.getVM();
            if (vm == null) {
                debugTarget.requestFailed(InstructionsEvaluationMessages.LocalVariableCreation_Execution_failed___VM_disconnected__1, new VMDisconnectedException());
            }
            type = JDIType.createType(debugTarget, PrimitiveTypeImpl.create((VirtualMachineImpl)vm, this.fTypeSignature));
        } else {
            type = this.fDimension == 0 ? this.getType(RuntimeSignature.toString(this.fTypeSignature)) : this.getArrayType(this.fTypeSignature, this.fDimension);
        }
        IVariable var = this.createInternalVariable(this.fName, type);
        if (this.fHasInitializer) {
            var.setValue((IValue)this.popValue());
        }
    }

    public String toString() {
        return NLS.bind((String)InstructionsEvaluationMessages.LocalVariableCreation_create_local_variable__0___1___1, (Object[])new String[]{this.fName, this.fTypeSignature});
    }
}

