/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.update.configurator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;

class Utils {
    public static boolean isWindows = System.getProperty("os.name").startsWith("Win");

    Utils() {
    }

    public static IStatus newStatus(String message, Throwable e) {
        return Status.error((String)message, (Throwable)e);
    }

    public static void log(String message) {
        Utils.log(Utils.newStatus(message, null));
    }

    public static void log(IStatus status) {
        ILog.of(Utils.class).log(status);
    }

    public static boolean isValidEnvironment(String os, String ws, String arch, String nl) {
        if (os != null && !Utils.isMatching(os, Utils.getOS())) {
            return false;
        }
        if (ws != null && !Utils.isMatching(ws, Utils.getWS())) {
            return false;
        }
        if (arch != null && !Utils.isMatching(arch, Utils.getArch())) {
            return false;
        }
        return nl == null || Utils.isMatchingLocale(nl, Utils.getNL());
    }

    public static String getOS() {
        return Platform.getOS();
    }

    public static String getWS() {
        return Platform.getWS();
    }

    public static String getArch() {
        return Platform.getOSArch();
    }

    public static String getNL() {
        return Platform.getNL();
    }

    public static Location getConfigurationLocation() {
        return Platform.getConfigurationLocation();
    }

    private static boolean isMatching(String candidateValues, String siteValues) {
        if (siteValues == null) {
            return false;
        }
        if ("*".equalsIgnoreCase(candidateValues)) {
            return true;
        }
        siteValues = siteValues.toUpperCase();
        StringTokenizer stok = new StringTokenizer(candidateValues, ",");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken().toUpperCase();
            if (!siteValues.contains(token)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMatchingLocale(String candidateValues, String locale) {
        if (locale == null) {
            return false;
        }
        if ("*".equalsIgnoreCase(candidateValues)) {
            return true;
        }
        locale = locale.toUpperCase();
        candidateValues = candidateValues.toUpperCase();
        StringTokenizer stok = new StringTokenizer(candidateValues, ",");
        while (stok.hasMoreTokens()) {
            String candidate = stok.nextToken();
            if (locale.indexOf(candidate) == 0) {
                return true;
            }
            if (candidate.indexOf(locale) != 0) continue;
            return true;
        }
        return false;
    }

    public static URL makeAbsolute(URL base, URL relativeLocation) {
        if (!"file".equals(base.getProtocol())) {
            return relativeLocation;
        }
        if (relativeLocation.getProtocol() != null && !relativeLocation.getProtocol().equals(base.getProtocol())) {
            return relativeLocation;
        }
        IPath relativePath = IPath.fromOSString((String)relativeLocation.getPath());
        if (relativePath.isAbsolute()) {
            return relativeLocation;
        }
        try {
            IPath absolutePath = IPath.fromOSString((String)base.getPath()).append(relativeLocation.getPath());
            return absolutePath.toFile().toURL();
        }
        catch (MalformedURLException e) {
            Utils.log(e.getLocalizedMessage());
            return relativeLocation;
        }
    }

    public static String canonicalizeURL(String url) {
        if (!isWindows || !url.startsWith("file:")) {
            return url;
        }
        try {
            String path = new URL(url).getPath();
            File file = new File(path);
            path = file.toString().replace('\\', '/');
            if (Character.isUpperCase(path.charAt(0))) {
                char[] chars = path.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                path = new String(chars);
                return new File(path).toURL().toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public static URL getInstallURL() {
        Location location = Platform.getInstallLocation();
        if (location == null) {
            throw new IllegalStateException("The installation location must not be null");
        }
        return location.getURL();
    }
}

