/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.acquire;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.io.KeyKeeper;
import org.eclipse.passage.lic.api.io.StreamCodec;
import org.eclipse.passage.lic.base.conditions.mining.DecodedContent;
import org.eclipse.passage.lic.base.io.FileCollection;
import org.eclipse.passage.lic.base.io.FloatingFileExtension;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.lic.base.io.PathFromLicensedProduct;
import org.eclipse.passage.lic.internal.emf.EObjectFromBytes;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LicensePacks {
    private final LicensedProduct product;
    private final KeyKeeper key;
    private final StreamCodec codec;
    private final Supplier<Path> base;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public LicensePacks(KeyKeeper key, StreamCodec codec, LicensedProduct product, Supplier<Path> base) {
        this.product = product;
        this.key = key;
        this.codec = codec;
        this.base = base;
    }

    Collection<FloatingLicensePack> get() throws LicensingException {
        return this.files().stream().map(this::pack).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Collection<Path> files() throws LicensingException {
        return new FileCollection((Supplier)new PathFromLicensedProduct(this.base, this.product), (PassageFileExtension)new FloatingFileExtension.FloatingLicenseEncrypted()).get();
    }

    private Optional<FloatingLicensePack> pack(Path license) {
        FloatingLicensePack pack;
        try {
            pack = (FloatingLicensePack)new EObjectFromBytes(this.decoded(license), LicensesPackage.eINSTANCE.getFloatingLicensePack()).get(Collections.singletonMap("http://www.eclipse.org/passage/lic/licenses/3.0.0", LicensesPackage.eINSTANCE));
        }
        catch (LicensingException e) {
            this.log.error("failed: ", (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(pack);
    }

    private byte[] decoded(Path source) throws LicensingException {
        return new DecodedContent(source, this.key, this.codec).get();
    }
}

