/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.api;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.passage.lic.api.MandatoryService;
import org.eclipse.passage.loc.internal.api.ClassSupply;
import org.eclipse.passage.loc.internal.api.ComposableClassSupply;
import org.eclipse.passage.loc.internal.api.InstanceSupply;

public final class ComposedClassSupply
implements ComposableClassSupply {
    private final Set<ClassSupply> registry = new LinkedHashSet<ClassSupply>();

    @Override
    public Optional<InstanceSupply<?>> find(Class<?> clazz, MandatoryService context) {
        for (ClassSupply supply : this.registry) {
            Optional<InstanceSupply<?>> find = supply.find(clazz, context);
            if (!find.isPresent()) continue;
            return Optional.of(find.get());
        }
        return Optional.empty();
    }

    @Override
    public void consider(ClassSupply fragment) {
        Objects.requireNonNull(fragment);
        this.registry.add(fragment);
    }

    @Override
    public void forget(ClassSupply fragment) {
        Objects.requireNonNull(fragment);
        this.registry.remove(fragment);
    }
}

