/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceExtensions<S>
implements Supplier<List<S>> {
    private final String namespace;
    private final String point;
    private final Class<S> service;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ServiceExtensions(String namespace, String point, Class<S> service) {
        Objects.requireNonNull(namespace, "ServiceExtensions::namespace");
        Objects.requireNonNull(point, "ServiceExtensions::point");
        Objects.requireNonNull(service, "ServiceExtensions::service");
        this.namespace = namespace;
        this.point = point;
        this.service = service;
    }

    @Override
    public List<S> get() {
        return Arrays.stream(this.extensions()).map(IExtension::getConfigurationElements).flatMap(Arrays::stream).map(this::service).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private IExtension[] extensions() {
        return Platform.getExtensionRegistry().getExtensionPoint(this.namespace, this.point).getExtensions();
    }

    private Optional<S> service(IConfigurationElement config) {
        try {
            Object executable = config.createExecutableExtension("class");
            return Optional.of(this.service.cast(executable));
        }
        catch (CoreException e) {
            this.log.error("failed to instanciate a service ", (Throwable)e);
            return Optional.empty();
        }
    }
}

