/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.access;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.base.io.ExternalLicense;
import org.eclipse.passage.lic.equinox.access.BaseOption;
import org.eclipse.passage.lic.equinox.access.CoverageCheckOptionDecision;
import org.eclipse.passage.lic.equinox.access.Interaction;

final class OptionImport
extends BaseOption<CoverageCheckOptionDecision> {
    private final LicensedProduct product;

    OptionImport(Interaction.Smart interaction, LicensedProduct product) {
        super('i', "Import", "Import a license for the application", interaction);
        this.product = product;
    }

    @Override
    public CoverageCheckOptionDecision run() {
        this.interaction.head("import license");
        this.interaction.prompt("Please enter path the a license file");
        this.readPath().ifPresent(this::install);
        return CoverageCheckOptionDecision.reassess;
    }

    private Optional<Path> readPath() {
        String path = this.interaction.input().trim();
        Path file = Paths.get(path, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            this.interaction.prompt(String.format("Path [%s] does not exist", file));
            return Optional.empty();
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            this.interaction.prompt(String.format("Path [%s] does not point to a file", file));
            return Optional.empty();
        }
        return Optional.of(file);
    }

    private void install(Path file) {
        try {
            Path installed = new ExternalLicense(this.product).install(new Path[]{file});
            this.interaction.prompt(String.format("License [%s] has been successfully installed in [%s]", file, installed));
        }
        catch (IOException e) {
            this.interaction.swear(e);
        }
    }
}

