/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.seal.internal.demo;

import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.acquire.LicenseAcquisitionServicesRegistry;
import org.eclipse.passage.lic.internal.api.conditions.mining.MinedConditionsRegistry;
import org.eclipse.passage.lic.internal.api.io.HashesRegistry;
import org.eclipse.passage.seal.internal.demo.BaseAccessCycleConfiguration;
import org.eclipse.passage.seal.internal.demo.FloatingLicensing;
import org.eclipse.passage.seal.internal.demo.LicensingDirection;
import org.eclipse.passage.seal.internal.demo.PersonalLicensing;
import org.osgi.framework.FrameworkUtil;

abstract class FocusedAccessCycleConfiguration
extends BaseAccessCycleConfiguration {
    protected LicensingDirection delegate;

    FocusedAccessCycleConfiguration(Supplier<LicensedProduct> product) {
        super(product, () -> FrameworkUtil.getBundle(FocusedAccessCycleConfiguration.class));
    }

    public MinedConditionsRegistry conditionMiners() {
        return this.delegate.conditionMiners();
    }

    public LicenseAcquisitionServicesRegistry acquirers() {
        return this.delegate.acquirers();
    }

    public HashesRegistry hashes() {
        return this.delegate.hashes();
    }

    static final class Floating
    extends FocusedAccessCycleConfiguration {
        Floating(Supplier<LicensedProduct> product) {
            super(product);
            this.delegate = new FloatingLicensing(super.keyKeepers(), super.codecs(), super.transports());
        }
    }

    static final class Personal
    extends FocusedAccessCycleConfiguration {
        Personal(Supplier<LicensedProduct> product) {
            super(product);
            this.delegate = new PersonalLicensing(() -> super.miningEquipment());
        }
    }

    static final class Wide
    extends FocusedAccessCycleConfiguration {
        Wide(Supplier<LicensedProduct> product) {
            super(product);
            this.delegate = new LicensingDirection.Joint(new PersonalLicensing(() -> super.miningEquipment()), new FloatingLicensing(super.keyKeepers(), super.codecs(), super.transports()));
        }
    }
}

