/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.ConditionAction;
import org.eclipse.passage.lic.internal.api.conditions.UserRole;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.base.NamedData;
import org.eclipse.passage.lic.internal.base.ProductIdentifier;
import org.eclipse.passage.lic.internal.base.ProductVersion;
import org.eclipse.passage.lic.internal.base.conditions.mining.LicensingContentType;
import org.eclipse.passage.lic.internal.equinox.io.InstallationPath;
import org.eclipse.passage.lic.internal.hc.i18n.HcMessages;
import org.eclipse.passage.lic.internal.hc.remote.Configuration;
import org.eclipse.passage.lic.internal.hc.remote.Request;
import org.eclipse.passage.lic.internal.hc.remote.impl.HttpUrlConnectionConfiguration;
import org.eclipse.passage.lic.internal.hc.remote.impl.TemporaryUser;
import org.eclipse.passage.lic.internal.net.LicensingAction;
import org.eclipse.passage.lic.internal.net.LicensingRole;
import org.eclipse.passage.lic.internal.net.LicensingServerCoordinates;

public final class RemoteConditionsRequest
implements Request<HttpURLConnection> {
    private final LicensedProduct product;
    private final Supplier<Path> settings;

    public RemoteConditionsRequest(LicensedProduct product, Supplier<Path> settings) {
        this.product = product;
        this.settings = settings;
    }

    public RemoteConditionsRequest(LicensedProduct product) {
        this(product, (Supplier<Path>)new InstallationPath());
    }

    @Override
    public URL url() throws LicensingException {
        try {
            LicensingServerCoordinates.HostPort corrdinates = new LicensingServerCoordinates(this.settings).get();
            return new URL("http", corrdinates.host(), Integer.parseInt(corrdinates.port()), this.query());
        }
        catch (UnsupportedEncodingException | NumberFormatException | MalformedURLException | LicensingException e) {
            throw new LicensingException(HcMessages.RemoteConditionsRequest_failed_to_compose_url, e);
        }
    }

    private String query() throws UnsupportedEncodingException {
        StringBuilder params = new StringBuilder();
        Arrays.stream(new NamedData[]{new ProductIdentifier(this.encode(this.product.identifier())), new ProductVersion(this.encode(this.product.version())), new LicensingAction((ConditionAction)new ConditionAction.Aquire()), new LicensingRole((UserRole)new UserRole.Admin()), new LicensingContentType((ContentType)new ContentType.Xml()), new TemporaryUser("12345678")}).map(NamedData.Writable::new).forEach(writable -> writable.write(params, "=", "&"));
        return String.valueOf('?') + params.toString();
    }

    private String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8");
    }

    @Override
    public Configuration<HttpURLConnection> config() {
        return new HttpUrlConnectionConfiguration(1000, new HashMap<String, String>());
    }
}

