/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Emission;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.PermissionEmittingService;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.SumOfCollections;

public final class Permissions
implements Supplier<ServiceInvocationResult<Collection<Permission>>> {
    private final Registry<StringServiceId, PermissionEmittingService> registry;
    private final Collection<ConditionPack> conditions;
    private final LicensedProduct product;

    public Permissions(Registry<StringServiceId, PermissionEmittingService> registry, Collection<ConditionPack> conditions, LicensedProduct product) {
        this.registry = registry;
        this.conditions = conditions;
        this.product = product;
    }

    @Override
    public ServiceInvocationResult<Collection<Permission>> get() {
        return this.registry.services().stream().map(service -> service.emit(this.conditions, this.product)).reduce(new BaseServiceInvocationResult.Sum(new SumOfCollections())).map(r -> new BaseServiceInvocationResult<Collection<Permission>>(r.diagnostic(), this.allPermissions(r.data()))).orElseGet(BaseServiceInvocationResult::new);
    }

    private Collection<Permission> allPermissions(Optional<Collection<Emission>> emissions) {
        if (!emissions.isPresent()) {
            return Collections.emptyList();
        }
        return emissions.get().stream().reduce(new ArrayList(), new SumEmissionsToData(), new SumOfCollections());
    }

    private static final class SumEmissionsToData
    implements BiFunction<Collection<Permission>, Emission, Collection<Permission>> {
        private SumEmissionsToData() {
        }

        @Override
        public Collection<Permission> apply(Collection<Permission> sum, Emission emission) {
            sum.addAll(emission.permissions());
            return sum;
        }
    }
}

