/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.meta.EntityMetadata;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.passage.loc.internal.workbench.wizards.BaseClassifierWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class BaseClassifierWizard<N extends BaseClassifierWizardPage>
extends Wizard {
    protected final EntityMetadata metadata;
    protected final EditingDomainRegistry<?> registry;
    protected N newClassifierPage;

    protected BaseClassifierWizard(EntityMetadata metadata, EditingDomainRegistry<?> registry) {
        this.metadata = metadata;
        this.registry = registry;
    }

    protected abstract N createNewClassifierPage();

    public void addPages() {
        this.newClassifierPage = this.createNewClassifierPage();
        this.addPage((IWizardPage)this.newClassifierPage);
    }

    public Optional<EObject> created() {
        return ((BaseClassifierWizardPage)((Object)this.newClassifierPage)).candidate().eResource() != null ? Optional.of(((BaseClassifierWizardPage)((Object)this.newClassifierPage)).candidate()) : Optional.empty();
    }

    protected ResourceSet resourceSet() {
        if (this.registry instanceof IEditingDomainProvider) {
            IEditingDomainProvider edProvider = (IEditingDomainProvider)this.registry;
            return edProvider.getEditingDomain().getResourceSet();
        }
        return new ResourceSetImpl();
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, m -> this.store());
            return true;
        }
        catch (InvocationTargetException exception) {
            this.failed(exception.getTargetException());
            return false;
        }
        catch (InterruptedException exception) {
            this.cancelled();
            return false;
        }
    }

    protected abstract void store();

    protected void failed(Throwable target) {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        Status status = new Status(4, bundle.getSymbolicName(), Optional.ofNullable(target).map(t -> t.getMessage()).orElse(WorkbenchMessages.BaseClassifierWizard_message_e_create), target);
        Platform.getLog(((Object)((Object)this)).getClass()).log((IStatus)status);
        ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.BaseClassifierWizard_title_e_create, (String)WorkbenchMessages.BaseClassifierWizard_message_e_create, (IStatus)status);
    }

    protected void cancelled() {
        MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.BaseClassifierWizard_title_e_create, (String)WorkbenchMessages.BaseClassifierWizard_message_e_create);
    }
}

