/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.passage.lic.api.LicensingReporter;
import org.eclipse.passage.lic.api.conditions.ConditionMiner;
import org.eclipse.passage.lic.api.conditions.ConditionTransport;
import org.eclipse.passage.lic.api.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.api.io.StreamCodecRegistry;
import org.eclipse.passage.lic.base.SystemReporter;

public abstract class BaseConditionMiner
implements ConditionMiner {
    protected LicensingReporter licensingReporter = SystemReporter.INSTANCE;
    protected KeyKeeperRegistry keyKeeperRegistry;
    protected StreamCodecRegistry streamCodecRegistry;
    protected final Map<String, ConditionTransport> conditionTransports = new HashMap<String, ConditionTransport>();

    protected void bindLicensingReporter(LicensingReporter reporter) {
        this.licensingReporter = reporter;
    }

    protected void unbindLicensingReporter(LicensingReporter reporter) {
        if (this.licensingReporter == reporter) {
            this.licensingReporter = SystemReporter.INSTANCE;
        }
    }

    protected void bindKeyKeeperRegistry(KeyKeeperRegistry registry) {
        this.keyKeeperRegistry = registry;
    }

    protected void unbindKeyKeeperRegistry(KeyKeeperRegistry registry) {
        if (this.keyKeeperRegistry == registry) {
            this.keyKeeperRegistry = null;
        }
    }

    protected void bindStreamCodecRegistry(StreamCodecRegistry registry) {
        this.streamCodecRegistry = registry;
    }

    protected void unbindStreamCodecRegistry(StreamCodecRegistry registry) {
        if (this.streamCodecRegistry == registry) {
            this.streamCodecRegistry = null;
        }
    }

    protected void bindConditionTransport(ConditionTransport transport, Map<String, Object> properties) {
        String contentType = String.valueOf(properties.get("licensing.content.type"));
        this.conditionTransports.put(contentType, transport);
    }

    protected void unbindConditionTransport(ConditionTransport transport, Map<String, Object> properties) {
        String contentType = String.valueOf(properties.get("licensing.content.type"));
        this.conditionTransports.remove(contentType, transport);
    }

    protected abstract String getBaseLocation();
}

