/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface.dialogs;

import java.util.Collections;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.access.AccessManager;
import org.eclipse.passage.lic.api.inspector.FeatureCase;
import org.eclipse.passage.lic.api.inspector.FeatureInspector;
import org.eclipse.passage.lic.api.inspector.HardwareInspector;
import org.eclipse.passage.lic.api.restrictions.RestrictionVerdict;
import org.eclipse.passage.lic.base.restrictions.RestrictionVerdicts;
import org.eclipse.passage.lic.equinox.ApplicationConfigurations;
import org.eclipse.passage.lic.equinox.LicensingEquinox;
import org.eclipse.passage.lic.internal.jface.i18n.JFaceMessages;
import org.eclipse.passage.lic.internal.jface.viewers.LicensingRequirementViewer;
import org.eclipse.passage.lic.jface.dialogs.HardwareInspectorDialog;
import org.eclipse.passage.lic.jface.dialogs.ImportLicenseDialog;
import org.eclipse.passage.lic.jface.dialogs.LicensingConfigurationDialog;
import org.eclipse.passage.lic.jface.resource.LicensingColors;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.lic.jface.viewers.RestrictionRepresenters;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class LicensingStatusDialog
extends TitleAreaDialog
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final int HARDWARE_INSPECTOR_ID = 1025;
    public static final int IMPORT_LICENSE_ID = 1026;
    public static final int SHOW_CONFIGURATION_ID = 1027;
    private final AccessManager accessManager;
    private final HardwareInspector hardwareInspector;
    private final FeatureInspector featureInspector;
    private final String[] features;
    private FeatureCase featureCase;
    private TableViewer tableViewer;
    IEclipsePreferences preferences = LicensingColors.getPreferences();
    private Iterable<RestrictionVerdict> restrictions = Collections.emptyList();

    public LicensingStatusDialog(Shell shell, String ... features) {
        super(shell);
        this.accessManager = LicensingEquinox.getAccessManager();
        this.featureInspector = LicensingEquinox.getFeatureInspector();
        this.hardwareInspector = LicensingEquinox.getHardwareInspector();
        this.features = new String[features.length];
        System.arraycopy(features, 0, this.features, 0, features.length);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JFaceMessages.LicensingStatusDialog_shell);
        newShell.setImage(LicensingStatusDialog.getDefaultImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(JFaceMessages.LicensingStatusDialog_title);
        Composite area = (Composite)super.createDialogArea(parent);
        this.createAreaContent(area);
        Dialog.applyDialogFont((Control)area);
        return area;
    }

    protected void computeStatus() {
        this.restrictions = this.featureCase.getRestrictions();
        RestrictionVerdict last = RestrictionVerdicts.resolveLastVerdict(this.restrictions);
        if (last == null) {
            this.setErrorMessage(null);
            this.setMessage(RestrictionRepresenters.resolveSummary(last));
        } else {
            this.setErrorMessage(RestrictionRepresenters.resolveSummary(last));
        }
        this.getContents().getDisplay().asyncExec(() -> this.updateTable());
    }

    protected void createAreaContent(Composite area) {
        Composite contents = new Composite(area, 0);
        contents.setLayout((Layout)new GridLayout(1, false));
        contents.setLayoutData((Object)new GridData(1808));
        Table tableDetails = new Table(contents, 2048);
        tableDetails.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = LicensingRequirementViewer.createTableViewer(tableDetails);
        this.setMessage(JFaceMessages.LicensingStatusDialog_ok_initilaizing);
        area.getDisplay().asyncExec(() -> this.initializeFeatureCase());
        Group contactsGroup = new Group(area, 0);
        contactsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        contactsGroup.setText(JFaceMessages.LicensingStatusDialog_contact_group);
        contactsGroup.setFont(JFaceResources.getDialogFont());
        contactsGroup.setLayout((Layout)new GridLayout());
        StyledText contactsText = new StyledText((Composite)contactsGroup, 10);
        contactsText.setLayoutData((Object)new GridData(4, 4, true, false));
        contactsText.setText(ApplicationConfigurations.getLicensingContacts());
        contactsText.setFont(JFaceResources.getDialogFont());
        if (this.preferences != null) {
            this.preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }

    protected void initializeFeatureCase() {
        this.featureCase = this.featureInspector.inspectFeatures(this.features);
        this.tableViewer.setInput((Object)this.featureCase.getRequirements());
        this.computeStatus();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        Button detailsButton = this.createButton(parent, 1027, JFaceMessages.LicensingStatusDialog_configuration_button, false);
        detailsButton.setImage(LicensingImages.getImage("IMG_DEFAULT"));
        detailsButton.setEnabled(this.accessManager != null);
        Button importButton = this.createButton(parent, 1026, JFaceMessages.LicensingStatusDialog_import_button, false);
        importButton.setImage(LicensingImages.getImage("IMG_IMPORT"));
        importButton.setEnabled(this.accessManager != null);
        Button inspector = this.createButton(parent, 1025, JFaceMessages.LicensingStatusDialog_hardware_button, false);
        inspector.setImage(LicensingImages.getImage("IMG_INSPECTOR"));
        inspector.setEnabled(this.hardwareInspector != null);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int length = button.getText().length();
        int widthHint = this.convertWidthInCharsToPixels(length + 8);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1027: {
                this.showConfigurationPressed();
                break;
            }
            case 1026: {
                this.importLicensePressed();
                break;
            }
            case 1025: {
                this.hardwareInspectorPressed();
                break;
            }
            default: {
                this.okPressed();
            }
        }
    }

    protected void showConfigurationPressed() {
        LicensingConfigurationDialog dialog = new LicensingConfigurationDialog(this.getShell());
        dialog.open();
    }

    protected void importLicensePressed() {
        LicensingConfiguration configuration = ApplicationConfigurations.getLicensingConfiguration();
        ImportLicenseDialog dialog = new ImportLicenseDialog(this.getShell(), configuration);
        if (dialog.open() == 0) {
            this.computeStatus();
        }
    }

    protected void hardwareInspectorPressed() {
        HardwareInspectorDialog dialog = new HardwareInspectorDialog(this.getShell(), this.hardwareInspector);
        dialog.open();
    }

    protected boolean isResizable() {
        return true;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        this.updateTable();
    }

    protected void updateTable() {
        if (this.tableViewer != null && this.tableViewer.getTable() != null && !this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    public boolean close() {
        if (this.preferences != null) {
            this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        this.featureCase.close();
        return super.close();
    }

    public Iterable<RestrictionVerdict> getRestrictions() {
        return this.restrictions;
    }
}

