/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.jface.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.passage.lic.jface.widgets.StatusLine;
import org.eclipse.passage.loc.jface.dialogs.ObjectSelectionDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ObjectSelectionStatusDialog
extends ObjectSelectionDialog {
    private StatusLine statusLine;
    private IStatus lastStatus;

    public ObjectSelectionStatusDialog(Shell shell) {
        super(shell);
    }

    protected abstract void computeResult();

    protected void updateStatus(IStatus status) {
        this.lastStatus = status;
        if (this.statusLine != null && !this.statusLine.isDisposed()) {
            this.updateButtonsEnableState(status);
            this.statusLine.setStatus(status);
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(!status.matches(4));
        }
    }

    protected void okPressed() {
        this.computeResult();
        super.okPressed();
    }

    public void create() {
        super.create();
        if (this.lastStatus != null) {
            this.updateStatus(this.lastStatus);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginLeft = this.convertHorizontalDLUsToPixels(7);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        if (this.isHelpAvailable()) {
            this.createHelpControl(composite);
        }
        this.statusLine = new StatusLine(composite);
        this.statusLine.setAlignment(16384);
        this.statusLine.setStatus(null);
        this.statusLine.setFont(font);
        this.statusLine.setLayoutData((Object)new GridData(768));
        boolean helpAvailable = this.isHelpAvailable();
        this.setHelpAvailable(false);
        super.createButtonBar(composite);
        this.setHelpAvailable(helpAvailable);
        return composite;
    }
}

