// This is a generated file, modify: generate/templates/templates/class_content.cc

#include <nan.h>
#include <string.h>

extern "C" {
#include <git2.h>
}

#include "../include/nodegit.h"
#include "../include/lock_master.h"
#include "../include/functions/copy.h"
#include "../include/odb_object.h"
#include "nodegit_wrapper.cc"
#include "../include/async_libgit2_queue_worker.h"

#include "../include/wrapper.h"
#include "node_buffer.h"
#include "../include/oid.h"

#include <iostream>

using namespace std;
using namespace v8;
using namespace node;

GitOdbObject::~GitOdbObject()
{
  // this will cause an error if you have a non-self-freeing object that also needs
  // to save values. Since the object that will eventually free the object has no
  // way of knowing to free these values.
}

void GitOdbObject::InitializeComponent(v8::Local<v8::Object> target)
{
  Nan::HandleScope scope;

  v8::Local<FunctionTemplate> tpl = Nan::New<FunctionTemplate>(JSNewFunction);

  tpl->InstanceTemplate()->SetInternalFieldCount(1);
  tpl->SetClassName(Nan::New("OdbObject").ToLocalChecked());

  Nan::SetPrototypeMethod(tpl, "data", Data);
  Nan::SetPrototypeMethod(tpl, "dup", Dup);
  Nan::SetPrototypeMethod(tpl, "free", Free);
  Nan::SetPrototypeMethod(tpl, "id", Id);
  Nan::SetPrototypeMethod(tpl, "size", Size);
  Nan::SetPrototypeMethod(tpl, "type", Type);

  InitializeTemplate(tpl);

  v8::Local<Function> _constructor_template = Nan::GetFunction(tpl).ToLocalChecked();
  constructor_template.Reset(_constructor_template);
  Nan::Set(target, Nan::New("OdbObject").ToLocalChecked(), _constructor_template);
}


/*
     * @return Buffer  result    */
NAN_METHOD(GitOdbObject::Data)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue()
                         );

    const void * result = git_odb_object_data(
                            Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue()
                          );

    // null checks on pointers
    if (!result) {
      return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
    }

    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (result != NULL) {
      // Wrapper result
      to = Wrapper::New(result);
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
     * @param OdbObject callback
   */
NAN_METHOD(GitOdbObject::Dup)
{

  if (info.Length() == 0 || !info[0]->IsFunction()) {
    return Nan::ThrowError("Callback is required and must be a Function.");
  }

  DupBaton* baton = new DupBaton;

  baton->error_code = GIT_OK;
  baton->error = NULL;

  baton->source = Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue();

  Nan::Callback *callback = new Nan::Callback(v8::Local<Function>::Cast(info[0]));
  DupWorker *worker = new DupWorker(baton, callback);
  worker->SaveToPersistent("source", info.This());

  AsyncLibgit2QueueWorker(worker);
  return;
}

void GitOdbObject::DupWorker::Execute()
{
  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */true,baton->source
                         );

    int result = git_odb_object_dup(
                   &baton->dest,baton->source    );

    baton->error_code = result;

    if (result != GIT_OK && giterr_last() != NULL) {
      baton->error = git_error_dup(giterr_last());
    }

  }
}

void GitOdbObject::DupWorker::HandleOKCallback()
{
  if (baton->error_code == GIT_OK) {
    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (baton->dest != NULL) {
      // GitOdbObject baton->dest
      to = GitOdbObject::New(baton->dest, false  );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    v8::Local<v8::Value> result = to;
    v8::Local<v8::Value> argv[2] = {
      Nan::Null(),
      result
    };
    callback->Call(2, argv);
  } else {
    if (baton->error) {
      v8::Local<v8::Object> err;
      if (baton->error->message) {
        err = Nan::Error(baton->error->message)->ToObject();
      } else {
        err = Nan::Error("Method dup has thrown an error.")->ToObject();
      }
      err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
      v8::Local<v8::Value> argv[1] = {
        err
      };
      callback->Call(1, argv);
      if (baton->error->message)
        free((void *)baton->error->message);
      free((void *)baton->error);
    } else if (baton->error_code < 0) {
      std::queue< v8::Local<v8::Value> > workerArguments;
      bool callbackFired = false;
      while(!workerArguments.empty()) {
        v8::Local<v8::Value> node = workerArguments.front();
        workerArguments.pop();

        if (
          !node->IsObject()
          || node->IsArray()
          || node->IsBooleanObject()
          || node->IsDate()
          || node->IsFunction()
          || node->IsNumberObject()
          || node->IsRegExp()
          || node->IsStringObject()
        ) {
          continue;
        }

        v8::Local<v8::Object> nodeObj = node->ToObject();
        v8::Local<v8::Value> checkValue = GetPrivate(nodeObj, Nan::New("NodeGitPromiseError").ToLocalChecked());

        if (!checkValue.IsEmpty() && !checkValue->IsNull() && !checkValue->IsUndefined()) {
          v8::Local<v8::Value> argv[1] = {
            checkValue->ToObject()
          };
          callback->Call(1, argv);
          callbackFired = true;
          break;
        }

        v8::Local<v8::Array> properties = nodeObj->GetPropertyNames();
        for (unsigned int propIndex = 0; propIndex < properties->Length(); ++propIndex) {
          v8::Local<v8::String> propName = properties->Get(propIndex)->ToString();
          v8::Local<v8::Value> nodeToQueue = nodeObj->Get(propName);
          if (!nodeToQueue->IsUndefined()) {
            workerArguments.push(nodeToQueue);
          }
        }
      }

      if (!callbackFired) {
        v8::Local<v8::Object> err = Nan::Error("Method dup has thrown an error.")->ToObject();
        err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
        v8::Local<v8::Value> argv[1] = {
          err
        };
        callback->Call(1, argv);
      }
    } else {
      callback->Call(0, NULL);
    }

  }


  delete baton;
}


/*
     */
NAN_METHOD(GitOdbObject::Free)
{
  Nan::EscapableHandleScope scope;

  if (Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue() != NULL) {

    giterr_clear();

    {
      LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue()
                           );

      git_odb_object_free(
        Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue()
      );

      Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->ClearValue();
    }
    return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
  }
}

/*
     * @return Oid  result    */
NAN_METHOD(GitOdbObject::Id)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue()
                         );

    const git_oid * result = git_odb_object_id(
                               Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue()
                             );

    // null checks on pointers
    if (!result) {
      return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
    }

    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (result != NULL) {
      // GitOid result
      to = GitOid::New(result, true, info.This() );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
     * @return Number  result    */
NAN_METHOD(GitOdbObject::Size)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue()
                         );

    size_t result = git_odb_object_size(
                      Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue()
                    );


    v8::Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
     * @return Number  result    */
NAN_METHOD(GitOdbObject::Type)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue()
                         );

    git_otype result = git_odb_object_type(
                         Nan::ObjectWrap::Unwrap<GitOdbObject>(info.This())->GetValue()
                       );


    v8::Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}
// force base class template instantiation, to make sure we get all the
// methods, statics, etc.
template class NodeGitWrapper<GitOdbObjectTraits>;
