/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.objects;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.logs.objects.ArchivedLogFileResource;
import org.eclipse.orion.server.logs.objects.FileAppenderResource;
import org.eclipse.orion.server.logs.objects.FixedWindowRollingPolicyResource;
import org.eclipse.orion.server.logs.objects.RollingPolicyResource;
import org.eclipse.orion.server.logs.objects.SizeBasedTriggeringPolicyResource;
import org.eclipse.orion.server.logs.objects.TimeBasedRollingPolicyResource;
import org.eclipse.orion.server.logs.objects.TriggeringPolicyResource;
import org.json.JSONArray;
import org.json.JSONObject;

@ResourceDescription(type="RollingFileAppender")
public class RollingFileAppenderResource
extends FileAppenderResource {
    public static final String RESOURCE = "rollingFileAppender";
    public static final String TYPE = "RollingFileAppender";
    protected RollingPolicyResource rollingPolicy;
    protected TriggeringPolicyResource triggeringPolicy;
    protected List<ArchivedLogFileResource> archivedLogFiles;

    public RollingFileAppenderResource(FileAppender<ILoggingEvent> fileAppender, URI baseLocation) {
        super(fileAppender, baseLocation);
        Property[] defaultProperties = new Property[]{new Property("RollingPolicy"), new Property("TriggeringPolicy"), new Property("ArchivedLogFiles")};
        Property[] baseProperties = DEFAULT_RESOURCE_SHAPE.getProperties();
        Property[] extendedProperties = new Property[baseProperties.length + defaultProperties.length];
        int i = 0;
        while (i < baseProperties.length) {
            extendedProperties[i] = baseProperties[i];
            ++i;
        }
        i = baseProperties.length;
        int j = 0;
        while (i < extendedProperties.length) {
            extendedProperties[i] = defaultProperties[j];
            ++i;
            ++j;
        }
        DEFAULT_RESOURCE_SHAPE.setProperties(extendedProperties);
    }

    public RollingFileAppenderResource(RollingFileAppender<ILoggingEvent> rollingFileAppender, URI baseLocation) {
        super((FileAppender<ILoggingEvent>)rollingFileAppender, baseLocation);
        TimeBasedRollingPolicy policy;
        Property[] defaultProperties = new Property[]{new Property("RollingPolicy"), new Property("TriggeringPolicy"), new Property("ArchivedLogFiles")};
        Property[] baseProperties = DEFAULT_RESOURCE_SHAPE.getProperties();
        Property[] extendedProperties = new Property[baseProperties.length + defaultProperties.length];
        int i = 0;
        while (i < baseProperties.length) {
            extendedProperties[i] = baseProperties[i];
            ++i;
        }
        i = baseProperties.length;
        int j = 0;
        while (i < extendedProperties.length) {
            extendedProperties[i] = defaultProperties[j];
            ++i;
            ++j;
        }
        DEFAULT_RESOURCE_SHAPE.setProperties(extendedProperties);
        RollingPolicy rollingPolicy = rollingFileAppender.getRollingPolicy();
        TriggeringPolicy triggeringPolicy = rollingFileAppender.getTriggeringPolicy();
        if (rollingPolicy instanceof TimeBasedRollingPolicy) {
            policy = (TimeBasedRollingPolicy)rollingPolicy;
            this.rollingPolicy = new TimeBasedRollingPolicyResource((TimeBasedRollingPolicy<ILoggingEvent>)policy);
        }
        if (rollingPolicy instanceof FixedWindowRollingPolicy) {
            policy = (FixedWindowRollingPolicy)rollingPolicy;
            this.rollingPolicy = new FixedWindowRollingPolicyResource((FixedWindowRollingPolicy)policy);
        }
        if (triggeringPolicy instanceof SizeBasedTriggeringPolicy) {
            policy = (SizeBasedTriggeringPolicy)triggeringPolicy;
            this.triggeringPolicy = new SizeBasedTriggeringPolicyResource((SizeBasedTriggeringPolicy<?>)policy);
        }
    }

    public RollingPolicyResource getRollingPolicy() {
        return this.rollingPolicy;
    }

    @PropertyDescription(name="RollingPolicy")
    public JSONObject getRollingPolicyJSON() throws URISyntaxException {
        if (this.rollingPolicy != null) {
            return this.rollingPolicy.toJSON();
        }
        return null;
    }

    public List<ArchivedLogFileResource> getArchivedLogFiles() {
        return this.archivedLogFiles;
    }

    @PropertyDescription(name="ArchivedLogFiles")
    public JSONArray getArchivedLogFilesJSON() throws URISyntaxException {
        if (this.archivedLogFiles == null) {
            return null;
        }
        JSONArray logFiles = new JSONArray();
        for (ArchivedLogFileResource logFile : this.archivedLogFiles) {
            logFiles.put((Object)logFile.toJSON());
        }
        return logFiles;
    }

    public void setArchivedLogFiles(List<ArchivedLogFileResource> archivedLogFiles) {
        this.archivedLogFiles = archivedLogFiles;
    }

    public void setRollingPolicy(RollingPolicyResource rollingPolicy) {
        this.rollingPolicy = rollingPolicy;
    }

    public TriggeringPolicyResource getTriggeringPolicy() {
        return this.triggeringPolicy;
    }

    @PropertyDescription(name="TriggeringPolicy")
    public JSONObject getTriggeringPolicyJSON() throws URISyntaxException {
        if (this.triggeringPolicy != null) {
            return this.triggeringPolicy.toJSON();
        }
        return null;
    }

    public void setTriggeringPolicy(TriggeringPolicyResource triggeringPolicy) {
        this.triggeringPolicy = triggeringPolicy;
    }

    @Override
    @PropertyDescription(name="Location")
    public URI getLocation() throws URISyntaxException {
        IPath path = new Path("/logapi").append(RESOURCE).append(this.getName());
        return this.createUriWithPath(path);
    }
}

