/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.Stash;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="StashCommit")
public class StashPage
extends GitObject {
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    protected Collection<RevCommit> stash;
    private int pageSize;
    private int page;
    private String messageFilter;

    public StashPage(URI cloneLocation, Repository db, Collection<RevCommit> stash, int page, int pageSize, String filter) {
        super(cloneLocation, db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("Children"), new Property("PreviousLocation"), new Property("NextLocation")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.stash = stash;
        this.page = Math.max(1, page);
        this.pageSize = Math.max(0, pageSize);
        this.messageFilter = filter;
    }

    @PropertyDescription(name="Children")
    protected JSONArray getChildren() throws GitAPIException, JSONException, URISyntaxException, IOException, CoreException {
        int toSkip = (this.page - 1) * this.pageSize;
        JSONArray children = new JSONArray();
        int curr = 1;
        int arrLength = 0;
        for (RevCommit revCommit : this.stash) {
            if (curr++ <= toSkip) continue;
            if (arrLength++ >= this.pageSize) break;
            Stash commit = new Stash(this.cloneLocation, this.db, revCommit, null);
            if (this.messageFilter != null && !this.messageFilter.equals("")) {
                if (!revCommit.getFullMessage().toLowerCase().contains(this.messageFilter.toLowerCase())) continue;
                children.put((Object)commit.toJSON());
                continue;
            }
            children.put((Object)commit.toJSON());
        }
        return children;
    }

    @PropertyDescription(name="PreviousLocation")
    protected URI getPreviousPageLocation() throws URISyntaxException {
        if (this.page > 1) {
            URI location = this.getLocation();
            String query = String.format("page=%d&pageSize=%d", this.page - 1, this.pageSize);
            return new URI(location.getScheme(), location.getAuthority(), location.getPath(), query, location.getFragment());
        }
        return null;
    }

    @PropertyDescription(name="NextLocation")
    protected URI getNextPageLocation() throws URISyntaxException {
        if (this.hasNextPage()) {
            URI location = this.getLocation();
            String query = String.format("page=%d&pageSize=%d", this.page + 1, this.pageSize);
            return new URI(location.getScheme(), location.getAuthority(), location.getPath(), query, location.getFragment());
        }
        return null;
    }

    protected boolean hasNextPage() {
        return this.stash.size() > this.page * this.pageSize;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        IPath stashPath = new Path("/gitapi").append("stash");
        IPath clonePath = new Path(this.cloneLocation.getPath()).removeFirstSegments(2);
        stashPath = stashPath.append(clonePath);
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getAuthority(), stashPath.toString(), null, null);
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }
}

