/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.cf.manifest.v2.Analyzer;
import org.eclipse.orion.server.cf.manifest.v2.AnalyzerException;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.ParserException;
import org.eclipse.orion.server.cf.manifest.v2.utils.ApplicationSanizator;
import org.eclipse.orion.server.cf.manifest.v2.utils.InheritanceUtils;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestParser;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestTransformator;
import org.eclipse.orion.server.cf.manifest.v2.utils.SymbolResolver;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ManifestUtils {
    private static final Pattern NON_SLUG_PATTERN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[\\s]");
    public static final String DEFAULT_MEMORY = "512M";
    public static final String DEFAULT_INSTANCES = "1";
    public static final String DEFAULT_PATH = ".";
    public static final String[] RESERVED_PROPERTIES = new String[]{"env", "inherit", "applications"};
    public static final String[] APPLICATION_PROPERTIES = new String[]{"name", "memory", "host", "buildpack", "command", "domain", "instances", "path", "timeout", "no-route", "services"};

    public static boolean isReserved(ManifestParseTree node) {
        String value = node.getLabel();
        String[] stringArray = RESERVED_PROPERTIES;
        int n = RESERVED_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (property.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isApplicationProperty(ManifestParseTree node) {
        String value = node.getLabel();
        String[] stringArray = APPLICATION_PROPERTIES;
        int n = APPLICATION_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (property.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static ManifestParseTree parseManifest(InputStream inputStream, String targetBase, Analyzer analyzer) throws IOException, ParserException, AnalyzerException {
        ManifestParser parser = new ManifestParser();
        ManifestParseTree parseTree = parser.parse(inputStream);
        ManifestTransformator transformator = new ManifestTransformator();
        transformator.apply(parseTree);
        SymbolResolver symbolResolver = new SymbolResolver(targetBase);
        symbolResolver.apply(parseTree);
        Analyzer applicationAnalyzer = analyzer != null ? analyzer : new ApplicationSanizator();
        applicationAnalyzer.apply(parseTree);
        return parseTree;
    }

    protected static ManifestParseTree parseManifest(IFileStore manifestFileStore, String targetBase, Analyzer analyzer) throws CoreException, IOException, ParserException, AnalyzerException {
        IFileInfo manifestFileInfo = manifestFileStore.fetchInfo();
        if (!manifestFileInfo.exists() || manifestFileInfo.isDirectory()) {
            throw new IOException("Could not read the manifest. Missing or invalid file.");
        }
        if (manifestFileInfo.getLength() == 0L) {
            throw new IOException("Empty manifest.");
        }
        if (manifestFileInfo.getLength() > 102400L) {
            throw new IOException("Refused to read the manifest. Exceeded maximum file size limit.");
        }
        InputStream inputStream = manifestFileStore.openInputStream(0, null);
        ManifestParseTree manifestTree = null;
        try {
            manifestTree = ManifestUtils.parseManifest(inputStream, targetBase, analyzer);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return manifestTree;
    }

    public static ManifestParseTree parse(IFileStore sandbox, IFileStore manifestStore, String targetBase, Analyzer analyzer, List<IPath> manifestList) throws CoreException, IOException, ParserException, AnalyzerException, InvalidAccessException {
        ManifestParseTree manifest = ManifestUtils.parseManifest(manifestStore, targetBase, analyzer);
        if (!manifest.has("inherit")) {
            return manifest;
        }
        Path parentLocation = new Path(manifest.get("inherit").getValue());
        if (!InheritanceUtils.isWithinSandbox(sandbox, manifestStore, (IPath)parentLocation)) {
            throw new AnalyzerException(NLS.bind((String)"Forbidden access to parent manifest {0}.", (Object)manifest.get("inherit").getValue()));
        }
        if (manifestList.contains(parentLocation)) {
            throw new AnalyzerException("Could not parse the manifest. Inheritance cycle detected.");
        }
        manifestList.add((IPath)parentLocation);
        IFileStore parentStore = manifestStore.getParent().getFileStore((IPath)parentLocation);
        ManifestParseTree parentManifest = ManifestUtils.parse(sandbox, parentStore, targetBase, analyzer, manifestList);
        InheritanceUtils.inherit(parentManifest, manifest);
        ManifestTransformator transformator = new ManifestTransformator();
        transformator.apply(manifest);
        return manifest;
    }

    public static ManifestParseTree parse(IFileStore sandbox, IFileStore manifestStore) throws CoreException, IOException, ParserException, AnalyzerException, InvalidAccessException {
        return ManifestUtils.parse(sandbox, manifestStore, null, null, new ArrayList<IPath>());
    }

    public static ManifestParseTree parse(IFileStore sandbox, IFileStore manifestStore, String targetBase) throws CoreException, IOException, ParserException, AnalyzerException, InvalidAccessException {
        return ManifestUtils.parse(sandbox, manifestStore, targetBase, null, new ArrayList<IPath>());
    }

    public static ManifestParseTree parse(IFileStore sandbox, IFileStore manifestStore, String targetBase, Analyzer analyzer) throws CoreException, IOException, ParserException, AnalyzerException, InvalidAccessException {
        return ManifestUtils.parse(sandbox, manifestStore, targetBase, analyzer, new ArrayList<IPath>());
    }

    public static int normalizeMemoryMeasure(String memory) {
        if (memory.toLowerCase().endsWith("m")) {
            return Integer.parseInt(memory.substring(0, memory.length() - 1));
        }
        if (memory.toLowerCase().endsWith("mb")) {
            return Integer.parseInt(memory.substring(0, memory.length() - 2));
        }
        if (memory.toLowerCase().endsWith("g")) {
            return 1024 * Integer.parseInt(memory.substring(0, memory.length() - 1));
        }
        if (memory.toLowerCase().endsWith("gb")) {
            return 1024 * Integer.parseInt(memory.substring(0, memory.length() - 2));
        }
        return 1024;
    }

    public static String slugify(String input) {
        input = WHITESPACE_PATTERN.matcher(input).replaceAll("");
        return NON_SLUG_PATTERN.matcher(input).replaceAll("");
    }

    public static ManifestParseTree parse(JSONObject manifestJSON) throws IllegalArgumentException, JSONException, IOException, ParserException, AnalyzerException {
        StringBuilder sb = new StringBuilder();
        sb.append("---").append(System.getProperty("line.separator"));
        ManifestUtils.append(sb, manifestJSON, 0, false);
        String manifestYAML = sb.toString();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(manifestYAML.getBytes("UTF-8"));
        ManifestParseTree manifestTree = null;
        try {
            manifestTree = ManifestUtils.parseManifest(inputStream, null, null);
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
        return manifestTree;
    }

    private static void appendIndentation(StringBuilder sb, int indentation) {
        int i = 0;
        while (i < indentation) {
            sb.append(" ");
            ++i;
        }
    }

    private static void append(StringBuilder sb, JSONArray arr, int indentation) throws JSONException {
        int i = 0;
        while (i < arr.length()) {
            ManifestUtils.appendIndentation(sb, indentation);
            sb.append("-").append(" ");
            Object val = arr.get(i);
            if (val instanceof String) {
                sb.append((String)val);
                sb.append(System.getProperty("line.separator"));
            } else if (val instanceof JSONObject) {
                JSONObject objVal = (JSONObject)val;
                ManifestUtils.append(sb, objVal, indentation + 2, false);
            } else {
                throw new IllegalArgumentException("Arrays may contain only JSON objects or string literals.");
            }
            ++i;
        }
    }

    private static void append(StringBuilder sb, JSONObject obj, int indentation, boolean indentFirst) throws JSONException {
        String[] names = JSONObject.getNames((JSONObject)obj);
        if (names == null) {
            return;
        }
        int i = 0;
        while (i < names.length) {
            String prop = names[i];
            if (i != 0 || indentFirst) {
                ManifestUtils.appendIndentation(sb, indentation);
            }
            sb.append(prop).append(":");
            Object val = obj.get(prop);
            if (val instanceof String) {
                sb.append(" ").append((String)val);
                sb.append(System.getProperty("line.separator"));
            } else if (val instanceof Boolean) {
                sb.append(" ").append(val.toString());
                sb.append(System.getProperty("line.separator"));
            } else if (val instanceof JSONObject) {
                JSONObject objVal = (JSONObject)val;
                sb.append(System.getProperty("line.separator"));
                ManifestUtils.append(sb, objVal, indentation + 2, true);
            } else if (val instanceof JSONArray) {
                JSONArray arr = (JSONArray)val;
                sb.append(System.getProperty("line.separator"));
                ManifestUtils.append(sb, arr, indentation);
            } else {
                throw new IllegalArgumentException("Objects may contain only JSON objects, arrays or string literals.");
            }
            ++i;
        }
    }

    public static ManifestParseTree createBoilerplate(String applicationName) throws IllegalArgumentException, JSONException, IOException, ParserException, AnalyzerException {
        JSONObject application = new JSONObject();
        application.put("name", (Object)applicationName);
        JSONArray applications = new JSONArray();
        applications.put((Object)application);
        JSONObject manifest = new JSONObject();
        manifest.put("applications", (Object)applications);
        return ManifestUtils.parse(manifest);
    }

    public static boolean hasMultipleApplications(ManifestParseTree manifest) {
        if (!manifest.has("applications")) {
            return false;
        }
        ManifestParseTree applications = manifest.getOpt("applications");
        if (!applications.isList()) {
            return false;
        }
        return applications.getChildren().size() > 1;
    }

    public static void instrumentManifest(ManifestParseTree manifest, JSONObject instrumentation) throws JSONException, InvalidAccessException {
        if (instrumentation == null || !manifest.has("applications")) {
            return;
        }
        List<ManifestParseTree> applications = manifest.get("applications").getChildren();
        if (instrumentation == null || instrumentation.length() == 0) {
            return;
        }
        String[] stringArray = JSONObject.getNames((JSONObject)instrumentation);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Object value = instrumentation.get(key);
            for (ManifestParseTree application : applications) {
                if ("memory".equals(key) && !ManifestUtils.updateMemory(application, (String)value)) continue;
                if (value instanceof String) {
                    application.put(key, (String)value);
                    continue;
                }
                if (!(value instanceof JSONObject)) continue;
                application.put(key, (JSONObject)value);
            }
            ++n2;
        }
    }

    private static boolean updateMemory(ManifestParseTree application, String value) {
        if (!application.has("memory")) {
            return true;
        }
        try {
            String appMemoryString = application.get("memory").getValue();
            int appMemory = ManifestUtils.normalizeMemoryMeasure(appMemoryString);
            int instrumentationMemory = ManifestUtils.normalizeMemoryMeasure(value);
            return instrumentationMemory > appMemory;
        }
        catch (InvalidAccessException invalidAccessException) {
            return true;
        }
    }
}

