/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.resources;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.Assert;
import org.eclipse.orion.server.core.resources.ReflectionHelper;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;

public class ResourceShapeFactory {
    public static ResourceShape createResourceShape(Class<?> resourceClass, String selectionQuery) {
        ResourceDescription resourceShapeDescription = resourceClass.getAnnotation(ResourceDescription.class);
        Assert.isNotNull((Object)resourceShapeDescription);
        if (selectionQuery == null) {
            return ResourceShapeFactory.getDefaultResourceShape(resourceClass);
        }
        String resourceShapeFieldName = ResourceShapeFactory.parseSelectionQuery(selectionQuery);
        return ResourceShapeFactory.getResourceShape(resourceClass, resourceShapeFieldName);
    }

    private static ResourceShape getDefaultResourceShape(Class<?> resourceClass) {
        return ResourceShapeFactory.getResourceShape(resourceClass, "DEFAULT_RESOURCE_SHAPE");
    }

    private static ResourceShape getResourceShape(Class<?> resourceClass, String resourceShapeFieldName) {
        Field field = ReflectionHelper.findFieldForName(resourceClass, resourceShapeFieldName);
        return (ResourceShape)ReflectionHelper.getValue(field);
    }

    private static String parseSelectionQuery(String selectionQuery) {
        return selectionQuery;
    }
}

