/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTMenu;
import org.eclipse.swt.internal.cocoa.SWTMenuItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    NSMenu nsMenu;
    int x;
    int y;
    int itemCount;
    boolean hasLocation;
    boolean visible;
    MenuItem[] items;
    MenuItem cascade;
    MenuItem defaultItem;
    Decorations parent;
    static final int GAP = 4;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = Menu.checkStyle(style);
        if (parent != null) {
            this.display = parent.display;
        } else {
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = Display.getDefault();
            }
            if (!this.display.isValidThread()) {
                this.error(22);
            }
        }
        this.parent = parent;
        this.reskinWidget();
        this.createWidget();
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    Menu(Display display) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.display = display;
        this.style = 2;
        this.reskinWidget();
        this.createWidget();
    }

    Menu(Display display, NSMenu nativeMenu) {
        this.display = display;
        this.style = 4;
        this.nsMenu = nativeMenu;
        this.reskinWidget();
        this.createWidget();
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    void checkParent(Widget parent) {
        if (parent == null && Display.getDefault().appMenuBar == null) {
            this.error(4);
        }
        if (parent != null) {
            if (parent.isDisposed()) {
                this.error(5);
            }
            parent.checkWidget();
            parent.checkOpen();
        }
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    void _setVisible(boolean visible) {
        if ((this.style & 6) != 0) {
            return;
        }
        TrayItem trayItem = this.display.currentTrayItem;
        if (trayItem != null && visible) {
            trayItem.showMenu(this);
            return;
        }
        if (visible) {
            Shell shell = this.getShell();
            NSWindow window = shell.view.window();
            NSPoint location = null;
            if (this.hasLocation) {
                NSView topView = window.contentView();
                Point shellCoord = this.display.map(null, (Control)shell, new Point(this.x, this.y));
                location = new NSPoint();
                float scaleFactor = window.userSpaceScaleFactor();
                location.x = (float)shellCoord.x * scaleFactor;
                location.y = (topView.frame().height - (float)shellCoord.y) * scaleFactor;
            } else {
                location = window.mouseLocationOutsideOfEventStream();
            }
            this.hasLocation = false;
            window.retain();
            NSEvent nsEvent = NSEvent.otherEventWithType(15, location, 0, 0.0, window.windowNumber(), window.graphicsContext(), (short)0, 0, 0);
            NSMenu.popUpContextMenu(this.nsMenu, nsEvent, shell.view);
            window.release();
        } else {
            this.nsMenu.cancelTracking();
        }
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    void createHandle() {
        this.display.addMenu(this);
        if (this.nsMenu == null) {
            NSMenu widget = (NSMenu)new SWTMenu().alloc();
            widget = widget.initWithTitle(NSString.string());
            widget.setAutoenablesItems(false);
            widget.setDelegate(widget);
            this.nsMenu = widget;
        } else {
            this.nsMenu.retain();
            int cls = OS.object_getClass(this.nsMenu.id);
            int dynNSMenu_class = this.display.createMenuSubclass(cls, "SWTSystemMenu", true);
            if (cls != dynNSMenu_class) {
                OS.object_setClass(this.nsMenu.id, dynNSMenu_class);
            }
            this.nsMenu.setDelegate(this.nsMenu);
        }
    }

    void createItem(MenuItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        boolean add = true;
        NSMenuItem nsItem = item.nsItem;
        if (nsItem == null) {
            if ((item.style & 2) != 0) {
                nsItem = NSMenuItem.separatorItem();
                nsItem.retain();
            } else {
                nsItem = (NSMenuItem)new SWTMenuItem().alloc();
                NSString empty = NSString.string();
                nsItem.initWithTitle(empty, 0, empty);
                nsItem.setTarget(nsItem);
                nsItem.setAction(OS.sel_sendSelection);
            }
            item.nsItem = nsItem;
        } else {
            int dynNSMenuItem_class;
            int cls = OS.object_getClass(nsItem.id);
            if (cls != (dynNSMenuItem_class = this.display.createMenuItemSubclass(cls, "SWTSystemMenuItem", true))) {
                OS.object_setClass(nsItem.id, dynNSMenuItem_class);
            }
            nsItem.retain();
            item.nsItemAction = nsItem.action();
            item.nsItemTarget = nsItem.target();
            nsItem.setTarget(nsItem);
            nsItem.setAction(OS.sel_sendSelection);
            int type = 8;
            if (nsItem.isSeparatorItem()) {
                type = 2;
            }
            if (nsItem.submenu() != null) {
                type = 64;
            }
            item.style |= type;
            item.text = nsItem.title().getString();
            int keyMask = nsItem.keyEquivalentModifierMask();
            NSString keyEquivString = nsItem.keyEquivalent();
            int keyEquiv = 0;
            if (keyEquivString != null) {
                keyEquiv = keyEquivString.characterAtIndex(0);
                if ((keyMask & 0x100000) != 0) {
                    keyEquiv |= 0x400000;
                }
                if ((keyMask & 0x80000) != 0) {
                    keyEquiv |= 0x10000;
                }
                item.accelerator = keyEquiv;
            }
            add = false;
        }
        item.createJNIRef();
        item.register();
        if (add) {
            this.nsMenu.insertItem(nsItem, index);
        }
        if (this.itemCount == this.items.length) {
            MenuItem[] newItems = new MenuItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
        if (add) {
            NSApplication application;
            NSMenu menubar;
            NSMenu emptyMenu = item.createEmptyMenu();
            if (emptyMenu != null) {
                nsItem.setSubmenu(emptyMenu);
                emptyMenu.release();
            }
            if (this.display.menuBar == this && (menubar = (application = this.display.application).mainMenu()) != null) {
                nsItem.setMenu(null);
                menubar.insertItem(nsItem, index + 1);
            }
        }
        if (!this.getEnabled()) {
            nsItem.setEnabled(false);
        }
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        super.createWidget();
        this.items = new MenuItem[4];
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsMenu);
    }

    void destroyItem(MenuItem item) {
        NSApplication application;
        NSMenu menubar;
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.items = new MenuItem[4];
        }
        this.nsMenu.removeItem(item.nsItem);
        if (this.display.menuBar == this && (menubar = (application = this.display.application).mainMenu()) != null) {
            NSMenuItem nsItem = item.nsItem;
            menubar.removeItem(nsItem);
        }
    }

    void fixMenus(Decorations newParent) {
        this.parent = newParent;
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        MenuItem[] result = new MenuItem[this.itemCount];
        int index = 0;
        if (this.items != null) {
            int i = 0;
            while (i < this.itemCount) {
                MenuItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    result[index++] = item;
                }
                ++i;
            }
        }
        if (index != result.length) {
            MenuItem[] newItems = new MenuItem[index];
            System.arraycopy(result, 0, newItems, 0, index);
            result = newItems;
        }
        return result;
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        if (this == this.display.appMenuBar) {
            return null;
        }
        return this.parent.getShell();
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            if (this == this.display.appMenuBar) {
                return this.display.application.isActive();
            }
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            Menu[] popups = this.display.popups;
            if (popups == null) {
                return false;
            }
            int i = 0;
            while (i < popups.length) {
                if (popups[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return this.visible;
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        if (this == this.display.appMenuBar) {
            return this.getEnabled();
        }
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void menu_willHighlightItem(int id2, int sel, int menu, int itemID) {
        Widget widget = this.display.getWidget(itemID);
        if (widget instanceof MenuItem) {
            MenuItem item = (MenuItem)widget;
            item.sendEvent(30);
        }
    }

    void menuNeedsUpdate(int id2, int sel, int menu) {
    }

    void menuWillOpen(int id2, int sel, int menu) {
        MenuItem item;
        this.visible = true;
        this.sendEvent(22);
        if (this.isDisposed()) {
            return;
        }
        float width = 0.0f;
        NSAttributedString[] strs = new NSAttributedString[this.itemCount];
        int i = 0;
        while (i < this.itemCount) {
            item = this.items[i];
            NSMenuItem nsItem = item.nsItem;
            strs[i] = nsItem.attributedTitle();
            NSImage nsImage = nsItem.image();
            float w = 4.0f;
            if (strs[i] != null) {
                w += strs[i].size().width;
            }
            if (nsImage != null) {
                w += nsImage.size().width + 4.0f;
            }
            if (strs[i] != null) {
                width = Math.max(width, w);
            }
            ++i;
        }
        i = 0;
        while (i < this.itemCount) {
            String accelText;
            int length;
            int accelIndex;
            item = this.items[i];
            if (!item.updateAccelerator(true) && item.accelerator == 0 && strs[i] != null && (this.style & 2) == 0 && (item.style & 0x40) == 0 && (accelIndex = item.text.indexOf(9)) != -1 && (length = (accelText = item.text.substring(accelIndex)).length()) > 1) {
                NSMenuItem nsItem = item.nsItem;
                NSImage nsImage = nsItem.image();
                float tab = width;
                if (nsImage != null) {
                    tab -= nsImage.size().width + 4.0f;
                }
                NSMutableAttributedString str = new NSMutableAttributedString(strs[i].mutableCopy());
                NSString label = (NSString)new NSString().alloc();
                label = label.initWithString(accelText);
                NSMutableDictionary dict = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(1);
                dict.setObject(NSFont.menuBarFontOfSize(0.0f), OS.NSFontAttributeName);
                NSAttributedString attribStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(label, dict);
                dict.release();
                label.release();
                str.appendAttributedString(attribStr);
                attribStr.release();
                NSRange range = new NSRange();
                range.length = str.length();
                NSMutableParagraphStyle paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
                paragraphStyle.setTabStops(NSArray.array());
                NSTextTab stop = (NSTextTab)new NSTextTab().alloc();
                stop = stop.initWithType(0, tab);
                paragraphStyle.addTabStop(stop);
                stop.release();
                str.addAttribute(OS.NSParagraphStyleAttributeName, paragraphStyle, range);
                paragraphStyle.release();
                nsItem.setAttributedTitle(str);
                str.release();
            }
            ++i;
        }
    }

    void menuDidClose(int id2, int sel, int menu) {
        this.sendEvent(23);
        if (this.isDisposed()) {
            return;
        }
        this.visible = false;
        int i = 0;
        while (i < this.itemCount) {
            MenuItem item = this.items[i];
            item.updateAccelerator(false);
            if ((item.style & 2) == 0) {
                item.updateText();
            }
            ++i;
        }
    }

    void register() {
        super.register();
        this.display.addWidget(this.nsMenu, this);
    }

    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                MenuItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.nsMenu != null) {
            this.nsMenu.release();
        }
        this.nsMenu = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this.parent != null && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.display.removeMenu(this);
        this.parent = null;
        this.defaultItem = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    void reskinChildren(int flags) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.reskin(flags);
            ++i;
        }
        super.reskinChildren(flags);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
        this.defaultItem = item;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        int i = 0;
        while (i < this.items.length) {
            MenuItem item = this.items[i];
            if (item != null) {
                item.nsItem.setEnabled(enabled && item.getEnabled());
            }
            ++i;
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

