/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.IGitHubTokenProvider;
import org.eclipse.orion.server.git.objects.PullRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ListPullRequestsJob
extends TaskJob {
    private HttpClient httpClient;
    private static final String CLIENT_KEY = "orion.oauth.github.client";
    private static final String CLIENT_SECRET = "orion.oauth.github.secret";
    private String url;
    private Repository db;
    private String remote;
    private URI cloneLocation;
    private String host;
    private String hostUser;
    private String project;
    private Cookie cookie;
    private String username;
    private String password;

    public ListPullRequestsJob(String userRunningTask, String url, URI cloneLocation, String host, String hostUser, String project, String username, String password, Object cookie) {
        super(userRunningTask, true);
        this.cloneLocation = cloneLocation;
        this.host = host;
        this.url = url;
        this.hostUser = hostUser;
        this.project = project;
        this.remote = userRunningTask;
        this.username = username;
        this.password = password;
        this.cookie = (Cookie)cookie;
        this.setFinalMessage("Getting Pull Requests Complete.");
        this.setTaskExpirationTime(TimeUnit.DAYS.toMillis(7L));
    }

    private IStatus doList(IProgressMonitor monitor) throws JSONException, URISyntaxException, HttpException, IOException, CoreException {
        JSONObject returnRes = new JSONObject();
        JSONArray resp = new JSONArray();
        String toCall = String.valueOf(this.host) + "repos/" + this.hostUser + "/" + this.project + "/pulls";
        String token = null;
        Enumeration<IGitHubTokenProvider> providers = GitCredentialsProvider.GetGitHubTokenProviders();
        while (providers.hasMoreElements()) {
            token = providers.nextElement().getToken(this.url, this.remote);
            if (token != null) break;
        }
        HttpClient hc = this.getHttpClient();
        if (token != null) {
            toCall = String.valueOf(toCall) + "?access_token=" + token;
        } else {
            String client_secret = PreferenceHelper.getString((String)CLIENT_SECRET);
            String client_key = PreferenceHelper.getString((String)CLIENT_KEY);
            toCall = String.valueOf(toCall) + "?client_id=" + client_key + "&client_secret=" + client_secret;
        }
        GetMethod m = new GetMethod(toCall);
        if (!this.username.isEmpty() && !this.password.isEmpty()) {
            String userCredentials = String.valueOf(this.username) + ":" + this.password;
            String basicAuth = "Basic " + new String(Base64.encode((byte[])userCredentials.getBytes()));
            m.setRequestHeader("Authorization", basicAuth);
        }
        try {
            hc.executeMethod((HttpMethod)m);
            int statusCode = m.getStatusCode();
            if (statusCode == 200) {
                String res = IOUtilities.toString((InputStream)m.getResponseBodyAsStream());
                resp = res.isEmpty() ? new JSONArray() : new JSONArray(res);
            } else if (statusCode == 401 || statusCode == 404) {
                String msg = "Repository not found, might be a private repository that requires authentication.";
                if (statusCode == 401) {
                    msg = "Not authorized to get the repository information.";
                }
                ServerStatus result = new ServerStatus(4, 401, msg, new JSONObject(), null);
                ServerStatus status = ServerStatus.convert((IStatus)result);
                JSONObject data = status.getJsonData();
                data.put("Url", (Object)this.url);
                try {
                    providers = GitCredentialsProvider.GetGitHubTokenProviders();
                    while (providers.hasMoreElements()) {
                        String authUrl = providers.nextElement().getAuthUrl(this.url, this.cookie);
                        if (authUrl == null) continue;
                        data.put("GitHubAuth", (Object)authUrl);
                        ServerStatus serverStatus = result;
                        return serverStatus;
                    }
                    ServerStatus serverStatus = result;
                    return serverStatus;
                }
                catch (Exception exception) {
                    ServerStatus serverStatus = result;
                    return serverStatus;
                }
            }
        }
        finally {
            m.releaseConnection();
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        if (resp != null) {
            int len = resp.length();
            int i = 0;
            while (i < len) {
                list.add(new JSONObject(resp.get(i).toString()));
                ++i;
            }
        }
        JSONArray children = new JSONArray();
        for (JSONObject prJson : list) {
            PullRequest pr = new PullRequest(this.cloneLocation, this.db, prJson);
            children.put((Object)pr.toJSON());
        }
        returnRes.put("Children", (Object)children);
        returnRes.put("Type", (Object)"PullRequest");
        return new ServerStatus(Status.OK_STATUS, 200, returnRes);
    }

    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
        }
        return this.httpClient;
    }

    protected IStatus performJob(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        try {
            result = this.doList(monitor);
        }
        catch (IOException e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error getting pull requests", (Throwable)e);
        }
        catch (CoreException e) {
            result = e.getStatus();
        }
        catch (Exception e) {
            result = new Status(4, "org.eclipse.orion.server.git", "Error getting pull requests", (Throwable)e);
        }
        return result;
    }
}

