/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.tasks;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.internal.server.core.tasks.TaskDescription;
import org.eclipse.orion.internal.server.core.tasks.TaskStore;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.tasks.CorruptedTaskException;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCleanupJob
extends Job {
    private TaskStore store;
    private Logger logger;
    private static final int RESCHEDULE_INTERVAL = 172800000;
    private static final int TEMPTASK_DELETE_THRESHOLD = 172800000;

    public TaskCleanupJob(TaskStore store) {
        super("Orion Task Cleanup");
        this.store = store;
        this.logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Orion task cleanup job started");
        }
        List<TaskDescription> allTasks = this.store.readAllTasks(true);
        long currentTime = System.currentTimeMillis();
        int removedCount = 0;
        for (TaskDescription taskDescription : allTasks) {
            try {
                Long timestamp;
                TaskInfo task = TaskInfo.fromJSON(taskDescription, this.store.readTask(taskDescription));
                if (task == null) continue;
                Long expires = task.getExpires();
                if (expires != null) {
                    if (expires >= currentTime) continue;
                    this.store.removeTask(taskDescription);
                    ++removedCount;
                    continue;
                }
                if (task.isKeep() || (timestamp = task.getTimestamp()) == null || 172800000L >= currentTime - timestamp) continue;
                this.store.removeTask(taskDescription);
                ++removedCount;
            }
            catch (CorruptedTaskException e) {
                LogHelper.log(e);
                this.store.removeTask(taskDescription);
            }
        }
        this.logger.info("Orion task cleanup job completed, removed task count: " + removedCount);
        this.schedule(172800000L);
        return Status.OK_STATUS;
    }
}

