/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.metastore;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;

public class SimpleUserPasswordUtil {
    public static final String ORION_STORAGE_PASSWORD = "orion.storage.password";
    private static final char SALT_SEPARATOR = ',';
    private static final String CHAR_ENCODING = "UTF-8";
    private static final String ENCRYPTION_ALGORITHM = "PBEWithMD5AndDES";

    public static String encryptPassword(String password) {
        try {
            byte[] salt = SimpleUserPasswordUtil.generateSalt();
            byte[] encryptedPassword = SimpleUserPasswordUtil.encryptPassword(password.getBytes(), salt);
            byte[] saltBase64 = Base64.encode(salt);
            byte[] encryptedPasswordBase64 = Base64.encode(encryptedPassword);
            String saltString = new String(saltBase64, CHAR_ENCODING);
            String encryptedPasswordString = new String(encryptedPasswordBase64, CHAR_ENCODING);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(saltString);
            stringBuffer.append(',');
            stringBuffer.append(encryptedPasswordString);
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LogHelper.log(e);
        }
        catch (UnsupportedEncodingException e) {
            LogHelper.log(e);
        }
        return null;
    }

    private static byte[] decryptPassword(byte[] password, byte[] salt) {
        try {
            byte[] decryptedPassword = null;
            PBEKeySpec pbeKeySpec = new PBEKeySpec(SimpleUserPasswordUtil.getPassword(), salt, 1024, 256);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ENCRYPTION_ALGORITHM);
            SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
            PBEParameterSpec pbeParameterSpec = new PBEParameterSpec(salt, 10);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(2, (Key)secretKey, pbeParameterSpec);
            decryptedPassword = cipher.doFinal(password);
            return decryptedPassword;
        }
        catch (NoSuchAlgorithmException e) {
            LogHelper.log(e);
        }
        catch (InvalidKeySpecException e) {
            LogHelper.log(e);
        }
        catch (InvalidKeyException e) {
            LogHelper.log(e);
        }
        catch (IllegalBlockSizeException e) {
            LogHelper.log(e);
        }
        catch (BadPaddingException e) {
            LogHelper.log(e);
        }
        catch (NoSuchPaddingException e) {
            LogHelper.log(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LogHelper.log(e);
        }
        return null;
    }

    private static byte[] encryptPassword(byte[] password, byte[] salt) {
        try {
            byte[] encryptedPassword = null;
            PBEKeySpec pbeKeySpec = new PBEKeySpec(SimpleUserPasswordUtil.getPassword(), salt, 1024, 256);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ENCRYPTION_ALGORITHM);
            SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
            PBEParameterSpec pbeParameterSpec = new PBEParameterSpec(salt, 10);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(1, (Key)secretKey, pbeParameterSpec);
            encryptedPassword = cipher.doFinal(password);
            return encryptedPassword;
        }
        catch (NoSuchAlgorithmException e) {
            LogHelper.log(e);
        }
        catch (InvalidKeySpecException e) {
            LogHelper.log(e);
        }
        catch (InvalidKeyException e) {
            LogHelper.log(e);
        }
        catch (IllegalBlockSizeException e) {
            LogHelper.log(e);
        }
        catch (BadPaddingException e) {
            LogHelper.log(e);
        }
        catch (NoSuchPaddingException e) {
            LogHelper.log(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LogHelper.log(e);
        }
        return null;
    }

    private static byte[] generateSalt() throws NoSuchAlgorithmException {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[8];
        secureRandom.nextBytes(salt);
        return salt;
    }

    private static boolean verifyPassword(String password, byte[] encryptedPassword, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] checkEncryptedPassword = SimpleUserPasswordUtil.encryptPassword(password.getBytes(), salt);
        return Arrays.equals(encryptedPassword, checkEncryptedPassword);
    }

    public static String decryptPassword(String encryptedText) {
        try {
            int saltPos = encryptedText.indexOf(44);
            if (saltPos == -1) {
                throw new RuntimeException("Invalid Data Format");
            }
            byte[] saltBase64 = encryptedText.substring(0, saltPos).getBytes(CHAR_ENCODING);
            byte[] encryptedPasswordBase64 = encryptedText.substring(saltPos + 1).getBytes(CHAR_ENCODING);
            byte[] salt = Base64.decode(saltBase64);
            byte[] encryptedPassword = Base64.decode(encryptedPasswordBase64);
            byte[] decryptedPassword = SimpleUserPasswordUtil.decryptPassword(encryptedPassword, salt);
            return new String(decryptedPassword);
        }
        catch (UnsupportedEncodingException e) {
            LogHelper.log(e);
            return null;
        }
    }

    public static boolean verifyPassword(String password, String encryptedText) {
        try {
            int saltPos = encryptedText.indexOf(44);
            if (saltPos == -1) {
                throw new RuntimeException("Invalid Data Format");
            }
            byte[] saltBase64 = encryptedText.substring(0, saltPos).getBytes(CHAR_ENCODING);
            byte[] encryptedPasswordBase64 = encryptedText.substring(saltPos + 1).getBytes(CHAR_ENCODING);
            byte[] salt = Base64.decode(saltBase64);
            byte[] encryptedPassword = Base64.decode(encryptedPasswordBase64);
            return SimpleUserPasswordUtil.verifyPassword(password, encryptedPassword, salt);
        }
        catch (NoSuchAlgorithmException e) {
            LogHelper.log(e);
        }
        catch (InvalidKeySpecException e) {
            LogHelper.log(e);
        }
        catch (UnsupportedEncodingException e) {
            LogHelper.log(e);
        }
        return false;
    }

    private static char[] getPassword() {
        String password = System.getProperty(ORION_STORAGE_PASSWORD, "unspecified");
        return password.toCharArray();
    }

    public static void main(String[] args) {
        System.out.println(SimpleUserPasswordUtil.encryptPassword(args[0]));
    }
}

