/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.agent;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetClusterHandler;
import com.sun.messaging.jmq.jmsserver.management.agent.ConnectorServerManager;
import com.sun.messaging.jmq.jmsserver.management.agent.MQRMIServerSocketFactory;
import com.sun.messaging.jmq.jmsserver.management.mbeans.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.BrokerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ClusterMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ConnectionConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ConnectionManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ConnectionMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ConsumerManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.DestinationConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.DestinationManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.DestinationMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.LogMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MessageManagerConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MessageManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ProducerManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ServiceConfig;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ServiceManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.ServiceMonitor;
import com.sun.messaging.jmq.jmsserver.management.mbeans.TransactionManagerMonitor;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.jmsserver.management.util.ServiceUtil;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.loading.MLet;

public class Agent {
    private static boolean DEBUG = Globals.getConfig().getBooleanProperty("imq.jmx.debug.all");
    private static String JMX_PROPBASE = "imq.jmx";
    private static String ENABLED = JMX_PROPBASE + ".enabled";
    private static String USE_PLATFORM_MBEANSERVER = JMX_PROPBASE + ".usePlatformMBeanServer";
    private static String MSG_MBEANS_ENABLED = JMX_PROPBASE + ".mbeans.msg.enabled";
    private static String MLET_ENABLED = JMX_PROPBASE + ".mlet.enabled";
    private static String MLET_FILE_URL = JMX_PROPBASE + ".mlet.file.url";
    private static String RMIREGISTRY_PROPBASE = JMX_PROPBASE + ".rmiregistry";
    private static String RMIREGISTRY_START = RMIREGISTRY_PROPBASE + ".start";
    private static String RMIREGISTRY_USE = RMIREGISTRY_PROPBASE + ".use";
    private static String RMIREGISTRY_PORT = RMIREGISTRY_PROPBASE + ".port";
    private MBeanServer mbs = null;
    private ConnectorServerManager csm = null;
    private Logger logger = null;
    private boolean active = false;
    private com.sun.messaging.jmq.jmsserver.config.BrokerConfig config = Globals.getConfig();
    private BrokerResources rb = null;
    private String mbeansPkgName = "com.sun.messaging.jmq.jmsserver.management.mbeans";
    private String[][] oneOnlyMBeans = new String[][]{{"JVMMonitor", "com.sun.messaging.jms.server:type=JVM,subtype=Monitor"}, {"BrokerConfig", "com.sun.messaging.jms.server:type=Broker,subtype=Config"}, {"ServiceManagerConfig", "com.sun.messaging.jms.server:type=ServiceManager,subtype=Config"}, {"DestinationManagerConfig", "com.sun.messaging.jms.server:type=DestinationManager,subtype=Config"}, {"ConnectionManagerConfig", "com.sun.messaging.jms.server:type=ConnectionManager,subtype=Config"}, {"ConsumerManagerConfig", "com.sun.messaging.jms.server:type=ConsumerManager,subtype=Config"}, {"ProducerManagerConfig", "com.sun.messaging.jms.server:type=ProducerManager,subtype=Config"}, {"TransactionManagerConfig", "com.sun.messaging.jms.server:type=TransactionManager,subtype=Config"}, {"ClusterConfig", "com.sun.messaging.jms.server:type=Cluster,subtype=Config"}, {"LogConfig", "com.sun.messaging.jms.server:type=Log,subtype=Config"}};
    private Map mbeans = Collections.synchronizedMap(new HashMap());
    private BrokerMonitor bkrMon;
    private ServiceManagerMonitor svcMgrMon;
    private ConnectionManagerMonitor cxnMgrMon;
    private DestinationManagerMonitor dstMgrMon;
    private ConsumerManagerMonitor conMgrMon;
    private ProducerManagerMonitor prdMgrMon;
    private TransactionManagerMonitor txnMgrMon;
    private ClusterMonitor clsMon;
    private LogMonitor logMon;
    private MessageManagerConfig msgMgrCon;
    private MessageManagerMonitor msgMgrMon;
    private MLet mqMLet = null;
    private String MQMLET_MBEAN_NAME = "com.sun.messaging.jms.server:type=MQMLet";
    private String MESSAGE_MANAGER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=MessageManager,subtype=Config";
    private String MESSAGE_MANAGER_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=MessageManager,subtype=Monitor";
    ClusterListener cl = new ClusterStateListener();

    public Agent() {
        this.init();
    }

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public void destroy() {
        Globals.getClusterManager().removeEventListener(this.cl);
    }

    public boolean isActive() {
        return this.active;
    }

    public void start() {
        if (!this.isActive()) {
            return;
        }
        try {
            this.csm.start();
        }
        catch (Exception e) {
            this.logger.logStack(16, "B2137", e);
        }
    }

    public void stop() {
        if (!this.isActive()) {
            return;
        }
        try {
            this.csm.stop();
        }
        catch (Exception e) {
            this.logger.log(16, "B2138", e);
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    public boolean useRmiRegistry() {
        return this.config.getBooleanProperty(RMIREGISTRY_USE);
    }

    public boolean msgMBeansEnabled() {
        return this.config.getBooleanProperty(MSG_MBEANS_ENABLED);
    }

    public boolean mletEnabled() {
        return this.config.getBooleanProperty(MLET_ENABLED);
    }

    public String getMLetFileURL() {
        return this.config.getProperty(MLET_FILE_URL);
    }

    public boolean startRmiRegistry() {
        return this.config.getBooleanProperty(RMIREGISTRY_START);
    }

    public int getRmiRegistryPort() {
        int port = this.config.getIntProperty(RMIREGISTRY_PORT, 0);
        if (port == 0) {
            port = 1099;
        }
        return port;
    }

    public ConnectorServerManager getConnectorServerManager() {
        return this.csm;
    }

    public void registerDestination(Destination d) {
        ObjectName o;
        if (!this.isActive()) {
            return;
        }
        if (!DestinationUtil.isVisibleDestination(d)) {
            return;
        }
        try {
            DestinationMonitor dm = new DestinationMonitor(d);
            o = MQObjectName.createDestinationMonitor(d.isQueue() ? "q" : "t", d.getDestinationName());
            this.agentRegisterMBean(dm, o);
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2139", "Destination Monitor"), e);
        }
        try {
            DestinationConfig dc = new DestinationConfig(d);
            o = MQObjectName.createDestinationConfig(d.isQueue() ? "q" : "t", d.getDestinationName());
            this.agentRegisterMBean(dc, o);
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2139", "Destination Config"), e);
        }
    }

    public void unregisterDestination(Destination d) {
        ObjectName o;
        if (!this.isActive()) {
            return;
        }
        if (!DestinationUtil.isVisibleDestination(d)) {
            return;
        }
        try {
            o = MQObjectName.createDestinationMonitor(d.isQueue() ? "q" : "t", d.getDestinationName());
            this.agentUnregisterMBean(o);
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2140", "Destination Monitor"), e);
        }
        try {
            o = MQObjectName.createDestinationConfig(d.isQueue() ? "q" : "t", d.getDestinationName());
            this.agentUnregisterMBean(o);
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2140", "Destination Config"), e);
        }
    }

    public void registerService(String service) {
        ObjectName o;
        if (!this.isActive()) {
            return;
        }
        try {
            ServiceMonitor sm = new ServiceMonitor(service);
            o = MQObjectName.createServiceMonitor(service);
            this.agentRegisterMBean(sm, o);
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2139", "Service Monitor"), e);
        }
        try {
            ServiceConfig sc = new ServiceConfig(service);
            o = MQObjectName.createServiceConfig(service);
            this.agentRegisterMBean(sc, o);
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2139", "Service Config"), e);
        }
    }

    public void unregisterService(String service) {
        if (!this.isActive()) {
            return;
        }
    }

    public void registerConnection(long id) {
        ObjectName o;
        if (!this.isActive()) {
            return;
        }
        try {
            ConnectionMonitor cm = new ConnectionMonitor(id);
            o = MQObjectName.createConnectionMonitor(Long.toString(id));
            this.agentRegisterMBean(cm, o);
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2139", "Connection Monitor"), e);
        }
        try {
            ConnectionConfig cc = new ConnectionConfig(id);
            o = MQObjectName.createConnectionConfig(Long.toString(id));
            this.agentRegisterMBean(cc, o);
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2139", "Connection Config"), e);
        }
    }

    public void unregisterConnection(long id) {
        ObjectName o;
        if (!this.isActive()) {
            return;
        }
        try {
            o = MQObjectName.createConnectionMonitor(Long.toString(id));
            this.agentUnregisterMBean(o);
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2140", "Connection Monitor"), e);
        }
        try {
            o = MQObjectName.createConnectionConfig(Long.toString(id));
            this.agentUnregisterMBean(o);
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2140", "Connection Config"), e);
        }
    }

    private void init() {
        this.logger = Globals.getLogger();
        this.rb = Globals.getBrokerResources();
        if (!this.jmxSupportEnabled()) {
            this.logger.log(16, "B2141");
            return;
        }
        try {
            Class.forName("javax.management.MBeanServer");
        }
        catch (Exception e) {
            this.logger.log(16, "B2142");
            return;
        }
        try {
            if (this.platformMBeanServerAvailable()) {
                if (this.usePlatformMBeanServer()) {
                    this.mbs = this.getPlatformMBeanServer();
                    this.logger.log(8, "B1239");
                } else {
                    this.mbs = this.createMBeanServer();
                    this.logger.log(8, "B1240");
                }
            } else {
                this.mbs = this.createMBeanServer();
                this.logger.log(8, "B1240");
            }
            this.startRMIRegistry();
            this.csm = new ConnectorServerManager(this);
            this.csm.initConfiguredConnectorServers();
        }
        catch (Exception e) {
            this.logger.log(16, "B2145", e);
            return;
        }
        Globals.getClusterManager().addEventListener(this.cl);
        this.active = true;
    }

    private MBeanServer getPlatformMBeanServer() throws BrokerException {
        MBeanServer mbeanServer = null;
        try {
            Class<?> c = Class.forName("java.lang.management.ManagementFactory");
            Method m = c.getMethod("getPlatformMBeanServer", null);
            mbeanServer = (MBeanServer)m.invoke((Object)"getPlatformMBeanServer", (Object[])null);
        }
        catch (Exception e) {
            throw new BrokerException(this.rb.getString("B2149", e.toString()));
        }
        return mbeanServer;
    }

    private void startRMIRegistry() throws BrokerException {
        Registry registry = null;
        boolean registryExists = false;
        if (!this.startRmiRegistry()) {
            return;
        }
        int port = this.getRmiRegistryPort();
        String jmxHostname = Globals.getJMXHostname();
        try {
            registry = jmxHostname != null && !jmxHostname.equals("*") ? LocateRegistry.getRegistry(jmxHostname, port) : LocateRegistry.getRegistry(port);
            registry.list();
            registryExists = true;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (registryExists) {
            throw new BrokerException(this.rb.getString("B2148", Integer.toString(port)));
        }
        try {
            if (jmxHostname != null && !jmxHostname.equals("*")) {
                MQRMIServerSocketFactory ssf = new MQRMIServerSocketFactory(jmxHostname, 0, false);
                registry = LocateRegistry.createRegistry(port, null, ssf);
            } else {
                registry = LocateRegistry.createRegistry(port);
            }
            registry.list();
            this.logger.log(8, this.rb.getString("B1241", Integer.toString(port)));
        }
        catch (RemoteException re) {
            throw new BrokerException(this.rb.getString("B2147", Integer.toString(port), re.toString()));
        }
    }

    public void loadMBeans() {
        try {
            this.loadAllMBeans();
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2150", e.toString()));
        }
    }

    private void loadAllMBeans() throws MalformedObjectNameException, ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        List dests;
        for (int i = 0; i < this.oneOnlyMBeans.length; ++i) {
            ObjectName mbeanName = new ObjectName(this.oneOnlyMBeans[i][1]);
            String mbeanClassName = this.mbeansPkgName + "." + this.oneOnlyMBeans[i][0];
            Object mbean = null;
            try {
                mbean = Class.forName(mbeanClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.agentRegisterMBean(mbean, mbeanName);
                continue;
            }
            catch (Exception e) {
                String name;
                if (mbean instanceof MQMBeanReadOnly) {
                    MQMBeanReadOnly mqmb = mbean;
                    name = mqmb.getMBeanName();
                } else {
                    name = mbeanName.toString();
                }
                this.logger.log(16, this.rb.getString("B2139", name), e);
            }
        }
        this.bkrMon = new BrokerMonitor();
        ObjectName objName = new ObjectName("com.sun.messaging.jms.server:type=Broker,subtype=Monitor");
        this.agentRegisterMBean(this.bkrMon, objName);
        this.svcMgrMon = new ServiceManagerMonitor();
        objName = new ObjectName("com.sun.messaging.jms.server:type=ServiceManager,subtype=Monitor");
        this.agentRegisterMBean(this.svcMgrMon, objName);
        this.dstMgrMon = new DestinationManagerMonitor();
        objName = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Monitor");
        this.agentRegisterMBean(this.dstMgrMon, objName);
        this.cxnMgrMon = new ConnectionManagerMonitor();
        objName = new ObjectName("com.sun.messaging.jms.server:type=ConnectionManager,subtype=Monitor");
        this.agentRegisterMBean(this.cxnMgrMon, objName);
        this.conMgrMon = new ConsumerManagerMonitor();
        objName = new ObjectName("com.sun.messaging.jms.server:type=ConsumerManager,subtype=Monitor");
        this.agentRegisterMBean(this.conMgrMon, objName);
        this.prdMgrMon = new ProducerManagerMonitor();
        objName = new ObjectName("com.sun.messaging.jms.server:type=ProducerManager,subtype=Monitor");
        this.agentRegisterMBean(this.prdMgrMon, objName);
        this.txnMgrMon = new TransactionManagerMonitor();
        objName = new ObjectName("com.sun.messaging.jms.server:type=TransactionManager,subtype=Monitor");
        this.agentRegisterMBean(this.txnMgrMon, objName);
        this.clsMon = new ClusterMonitor();
        objName = new ObjectName("com.sun.messaging.jms.server:type=Cluster,subtype=Monitor");
        this.agentRegisterMBean(this.clsMon, objName);
        this.logMon = new LogMonitor();
        objName = new ObjectName("com.sun.messaging.jms.server:type=Log,subtype=Monitor");
        this.agentRegisterMBean(this.logMon, objName);
        if (this.msgMBeansEnabled()) {
            this.msgMgrMon = new MessageManagerMonitor();
            objName = new ObjectName(this.MESSAGE_MANAGER_MONITOR_MBEAN_NAME);
            this.agentRegisterMBean(this.msgMgrMon, objName);
            this.msgMgrCon = new MessageManagerConfig();
            objName = new ObjectName(this.MESSAGE_MANAGER_CONFIG_MBEAN_NAME);
            this.agentRegisterMBean(this.msgMgrCon, objName);
        }
        if ((dests = DestinationUtil.getVisibleDestinations()).size() != 0) {
            for (int i = 0; i < dests.size(); ++i) {
                Destination d = (Destination)dests.get(i);
                this.registerDestination(d);
            }
        }
        List svcs = ServiceUtil.getVisibleServiceNames();
        for (String service : svcs) {
            this.registerService(service);
        }
        if (this.mletEnabled()) {
            String url;
            try {
                ObjectName mletName = new ObjectName(this.MQMLET_MBEAN_NAME);
                this.mqMLet = new MLet();
                this.agentRegisterMBean(this.mqMLet, mletName);
                this.logger.log(8, "MLET: Registering MLet MBean");
            }
            catch (Exception e) {
                String name = "MQMLet";
                this.logger.log(16, this.rb.getString("B2139", name), e);
            }
            if (this.mqMLet != null && (url = this.getMLetFileURL()) != null && !url.equals("")) {
                try {
                    this.logger.log(8, "MLET: Loading MBeans from MLet file: " + url);
                    Set<Object> loadedMBeans = this.mqMLet.getMBeansFromURL(url);
                    if (loadedMBeans != null) {
                        for (Object obj : loadedMBeans) {
                            if (obj instanceof ObjectInstance) {
                                ObjectInstance objInst = (ObjectInstance)obj;
                                this.logger.log(8, "MLET: Loaded MBean [objectname=" + objInst.getObjectName().toString() + ", class=" + objInst.getClassName() + "]");
                                continue;
                            }
                            if (obj instanceof Throwable) {
                                Throwable thr = (Throwable)obj;
                                this.logger.log(16, "MLET: Failed to load MBean: " + thr);
                                continue;
                            }
                            this.logger.log(16, "MLET: Unknown object type returned by MLet MBean creation: " + obj);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.log(16, "Exception caught while loading MBeans via MQMLet", e);
                }
            }
        }
    }

    public void unloadMBeans() {
        if (!this.isActive()) {
            return;
        }
        List svcs = ServiceUtil.getVisibleServiceNames();
        for (String service : svcs) {
            this.unregisterService(service);
        }
        try {
            this.agentUnregisterAllMBeans();
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2151", e.toString()));
        }
    }

    public void notifyQuiesceStart() {
        if (this.bkrMon != null) {
            this.bkrMon.notifyQuiesceStart();
        }
    }

    public void notifyQuiesceComplete() {
        if (this.bkrMon != null) {
            this.bkrMon.notifyQuiesceComplete();
        }
    }

    public void notifyShutdownStart() {
        if (this.bkrMon != null) {
            this.bkrMon.notifyShutdownStart();
        }
    }

    public void notifyTakeoverStart(String brokerID) {
        if (this.bkrMon != null) {
            this.bkrMon.notifyTakeoverStart(brokerID);
        }
        if (this.clsMon != null) {
            this.clsMon.notifyTakeoverStart(brokerID);
        }
    }

    public void notifyTakeoverComplete(String brokerID) {
        if (this.bkrMon != null) {
            this.bkrMon.notifyTakeoverComplete(brokerID);
        }
        if (this.clsMon != null) {
            this.clsMon.notifyTakeoverComplete(brokerID);
        }
    }

    public void notifyTakeoverFail(String brokerID) {
        if (this.bkrMon != null) {
            this.bkrMon.notifyTakeoverFail(brokerID);
        }
        if (this.clsMon != null) {
            this.clsMon.notifyTakeoverFail(brokerID);
        }
    }

    public void notifyClusterBrokerDown(String brokerID) {
        if (this.clsMon != null) {
            this.clsMon.notifyClusterBrokerDown(brokerID);
        }
    }

    public void notifyClusterBrokerJoin(String brokerID) {
        if (this.clsMon != null) {
            this.clsMon.notifyClusterBrokerJoin(brokerID);
        }
        if (this.bkrMon != null) {
            this.bkrMon.notifyClusterBrokerJoin(brokerID);
        }
    }

    public void notifyServicePause(String serviceName) {
        if (serviceName == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.service.pause"));
            this.logger.log(16, "B2155");
            return;
        }
        if (this.svcMgrMon != null) {
            this.svcMgrMon.notifyServicePause(serviceName);
        }
        ObjectName o = null;
        try {
            o = MQObjectName.createServiceMonitor(serviceName);
            ServiceMonitor sm = (ServiceMonitor)this.getMBean(o);
            if (sm != null) {
                sm.notifyServicePause();
            }
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2152", "mq.service.pause", o + "[" + serviceName + "]"), e);
        }
    }

    public void notifyServiceResume(String serviceName) {
        if (serviceName == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.service.resume"));
            this.logger.log(16, "B2155");
            return;
        }
        if (this.svcMgrMon != null) {
            this.svcMgrMon.notifyServiceResume(serviceName);
        }
        ObjectName o = null;
        try {
            o = MQObjectName.createServiceMonitor(serviceName);
            ServiceMonitor sm = (ServiceMonitor)this.getMBean(o);
            if (sm != null) {
                sm.notifyServiceResume();
            }
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2152", "mq.service.resume", o + "[" + serviceName + "]"), e);
        }
    }

    public void notifyConnectionOpen(long id) {
        String serviceName;
        if (this.cxnMgrMon != null) {
            this.cxnMgrMon.notifyConnectionOpen(id);
        }
        if ((serviceName = ConnectionUtil.getServiceOfConnection(id)) == null) {
            this.logger.log(16, this.rb.getString("B2154", "mq.connection.open", "Service Monitor"));
            this.logger.log(16, this.rb.getString("B2156", Long.toString(id)));
            return;
        }
        ObjectName o = null;
        try {
            o = MQObjectName.createServiceMonitor(serviceName);
            ServiceMonitor sm = (ServiceMonitor)this.getMBean(o);
            if (sm != null) {
                sm.notifyConnectionOpen(id);
            }
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2152", "mq.connection.open", o + "[" + serviceName + "]"), e);
        }
    }

    public void notifyConnectionClose(long id) {
        String serviceName;
        if (this.cxnMgrMon != null) {
            this.cxnMgrMon.notifyConnectionClose(id);
        }
        if ((serviceName = ConnectionUtil.getServiceOfConnection(id)) == null) {
            this.logger.log(16, this.rb.getString("B2154", "mq.connection.close", "Service Monitor"));
            this.logger.log(16, this.rb.getString("B2156", Long.toString(id)));
            return;
        }
        ObjectName o = null;
        try {
            o = MQObjectName.createServiceMonitor(serviceName);
            ServiceMonitor sm = (ServiceMonitor)this.getMBean(o);
            if (sm != null) {
                sm.notifyConnectionClose(id);
            }
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2152", "mq.connection.close", o + "[" + serviceName + "]"), e);
        }
    }

    public void notifyConnectionReject(String serviceName, String userName, String remoteHostString) {
        if (serviceName == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.connection.reject"));
            this.logger.log(16, "B2155");
            return;
        }
        if (this.cxnMgrMon != null) {
            this.cxnMgrMon.notifyConnectionReject(serviceName, userName, remoteHostString);
        }
        ObjectName o = null;
        try {
            o = MQObjectName.createServiceMonitor(serviceName);
            ServiceMonitor sm = (ServiceMonitor)this.getMBean(o);
            if (sm != null) {
                sm.notifyConnectionReject(serviceName, userName, remoteHostString);
            }
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2152", "mq.connection.reject", o + "[" + serviceName + "]"), e);
        }
    }

    public void notifyDestinationAttrUpdated(Destination d, int attr, Object oldVal, Object newVal) {
        if (d == null || !DestinationUtil.isVisibleDestination(d)) {
            return;
        }
        ObjectName o = null;
        try {
            o = DestinationUtil.getConfigObjectName(d);
            DestinationConfig dc = (DestinationConfig)this.getMBean(o);
            if (dc != null) {
                Object tmp = DestinationUtil.convertAttrValueInternaltoExternal(attr, oldVal);
                Object tmp2 = DestinationUtil.convertAttrValueInternaltoExternal(attr, newVal);
                dc.notifyDestinationAttrUpdated(attr, tmp, tmp2);
            }
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2152", "jmx.attribute.change", o + "[" + d + "]"), e);
        }
    }

    public void notifyServiceAttrUpdated(String svcName, String attr, Object oldVal, Object newVal) {
    }

    public void notifyDestinationCompact(Destination d) {
        if (d == null || !DestinationUtil.isVisibleDestination(d)) {
            return;
        }
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationCompact(d);
        }
        ObjectName o = null;
        try {
            o = DestinationUtil.getMonitorObjectName(d);
            DestinationMonitor dm = (DestinationMonitor)this.getMBean(o);
            if (dm != null) {
                dm.notifyDestinationCompact();
            }
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2152", "mq.destination.compact", o + "[" + d + "]"), e);
        }
    }

    public void notifyDestinationCreate(Destination d) {
        if (d == null || !DestinationUtil.isVisibleDestination(d)) {
            return;
        }
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationCreate(d);
        }
    }

    public void notifyDestinationDestroy(Destination d) {
        if (d == null || !DestinationUtil.isVisibleDestination(d)) {
            return;
        }
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationDestroy(d);
        }
    }

    public void notifyDestinationPause(Destination d, int internalPauseType) {
        if (d == null || !DestinationUtil.isVisibleDestination(d)) {
            return;
        }
        String externalPauseType = DestinationUtil.toExternalPauseType(internalPauseType);
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationPause(d, externalPauseType);
        }
        ObjectName o = null;
        try {
            o = DestinationUtil.getMonitorObjectName(d);
            DestinationMonitor dm = (DestinationMonitor)this.getMBean(o);
            if (dm != null) {
                dm.notifyDestinationPause(externalPauseType);
            }
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2152", "mq.destination.pause", o + "[" + d + "]"), e);
        }
    }

    public void notifyDestinationPurge(Destination d) {
        if (d == null || !DestinationUtil.isVisibleDestination(d)) {
            return;
        }
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationPurge(d);
        }
        ObjectName o = null;
        try {
            o = DestinationUtil.getMonitorObjectName(d);
            DestinationMonitor dm = (DestinationMonitor)this.getMBean(o);
            if (dm != null) {
                dm.notifyDestinationPurge();
            }
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2152", "mq.destination.purge", o + "[" + d + "]"), e);
        }
    }

    public void notifyDestinationResume(Destination d) {
        if (d == null || !DestinationUtil.isVisibleDestination(d)) {
            return;
        }
        if (this.dstMgrMon != null) {
            this.dstMgrMon.notifyDestinationResume(d);
        }
        ObjectName o = null;
        try {
            o = DestinationUtil.getMonitorObjectName(d);
            DestinationMonitor dm = (DestinationMonitor)this.getMBean(o);
            if (dm != null) {
                dm.notifyDestinationResume();
            }
        }
        catch (Exception e) {
            this.logger.log(16, this.rb.getString("B2152", "mq.destination.resume", o + "[" + d + "]"), e);
        }
    }

    public void notifyTransactionCommit(TransactionUID tid) {
        if (tid == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.transaction.commit"));
            this.logger.log(16, "B2159");
            return;
        }
        long id = tid.longValue();
        if (this.txnMgrMon != null) {
            this.txnMgrMon.notifyTransactionCommit(id);
        }
    }

    public void notifyTransactionPrepare(TransactionUID tid) {
        if (tid == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.transaction.prepare"));
            this.logger.log(16, "B2159");
            return;
        }
        long id = tid.longValue();
        if (this.txnMgrMon != null) {
            this.txnMgrMon.notifyTransactionPrepare(id);
        }
    }

    public void notifyTransactionRollback(TransactionUID tid) {
        if (tid == null) {
            this.logger.log(16, this.rb.getString("B2153", "mq.transaction.rollback"));
            this.logger.log(16, "B2159");
            return;
        }
        long id = tid.longValue();
        if (this.txnMgrMon != null) {
            this.txnMgrMon.notifyTransactionRollback(id);
        }
    }

    public void notifyLogMessage(int level, String message) {
        if (this.logMon != null) {
            String levelStr = Logger.jullevelIntToStr(level);
            try {
                this.logMon.notifyLogMessage(levelStr, message);
            }
            catch (Exception e) {
                this.logger.log(16, this.rb.getString("B2152", "mq.log.level." + levelStr, "Log Monitor"), e);
            }
        }
    }

    public void notifyResourceStateChange(String oldResourceState, String newResourceState, MemoryUsage heapMemoryUsage) {
        if (this.bkrMon != null) {
            this.bkrMon.notifyResourceStateChange(oldResourceState, newResourceState, heapMemoryUsage);
        }
    }

    public void portMapperPortUpdated(Integer oldPort, Integer newPort) {
    }

    public void resetMetrics() {
        if (this.cxnMgrMon != null) {
            this.cxnMgrMon.resetMetrics();
        }
        if (this.txnMgrMon != null) {
            this.txnMgrMon.resetMetrics();
        }
        List svcs = ServiceUtil.getVisibleServiceNames();
        for (String service : svcs) {
            ServiceMonitor sm = this.getServiceMonitorMBean(service);
            if (sm == null) continue;
            sm.resetMetrics();
        }
    }

    public BrokerConfig getBrokerConfigMBean() {
        BrokerConfig bc = null;
        Exception ex = null;
        try {
            ObjectName o = new ObjectName("com.sun.messaging.jms.server:type=Broker,subtype=Config");
            bc = (BrokerConfig)this.getMBean(o);
        }
        catch (Exception e) {
            ex = e;
        }
        if (bc == null && DEBUG) {
            this.logger.log(4, "Exception caught when obtaining handle to BrokerConfig MBean: " + (ex == null ? "" : ex.toString()));
        }
        return bc;
    }

    public BrokerMonitor getBrokerMonitorMBean() {
        return this.bkrMon;
    }

    public ServiceConfig getServiceConfigMBean(String svc) {
        ServiceConfig sc = null;
        Exception ex = null;
        try {
            ObjectName o = MQObjectName.createServiceConfig(svc);
            sc = (ServiceConfig)this.getMBean(o);
        }
        catch (Exception e) {
            ex = e;
        }
        if (sc == null && DEBUG) {
            this.logger.log(4, "Exception caught when obtaining handle to ServiceConfig MBean: " + (ex == null ? "" : ex.toString()));
        }
        return sc;
    }

    public ServiceMonitor getServiceMonitorMBean(String svc) {
        ServiceMonitor sm = null;
        Exception ex = null;
        try {
            ObjectName o = MQObjectName.createServiceMonitor(svc);
            sm = (ServiceMonitor)this.getMBean(o);
        }
        catch (Exception e) {
            ex = e;
        }
        if (sm == null && DEBUG) {
            this.logger.log(4, "Exception caught when obtaining handle to ServiceMonitor MBean: " + (ex == null ? "" : ex.toString()));
        }
        return sm;
    }

    public DestinationConfig getDestinationConfigMBean(String name, String type) {
        DestinationConfig dc = null;
        Exception ex = null;
        try {
            ObjectName o = MQObjectName.createDestinationConfig(type, name);
            dc = (DestinationConfig)this.getMBean(o);
        }
        catch (Exception e) {
            ex = e;
        }
        if (dc == null && DEBUG) {
            this.logger.log(4, "Exception caught when obtaining handle to DestinationConfig MBean: " + (ex == null ? "" : ex.toString()));
        }
        return dc;
    }

    public DestinationMonitor getDestinationMonitorMBean(String name, String type) {
        DestinationMonitor dm = null;
        Exception ex = null;
        try {
            ObjectName o = MQObjectName.createDestinationMonitor(type, name);
            dm = (DestinationMonitor)this.getMBean(o);
        }
        catch (Exception e) {
            ex = e;
        }
        if (dm == null && DEBUG) {
            this.logger.log(4, "Exception caught when obtaining handle to DestinationMonitor MBean: " + (ex == null ? "" : ex.toString()));
        }
        return dm;
    }

    public String getDefaultJMXUrlPathBase() throws BrokerException {
        MQAddress addr = Globals.getMQAddress();
        if (addr == null) {
            return null;
        }
        String brokerHostName = addr.getHostName();
        String rmiRegHostName = Globals.getJMXHostname();
        int brokerPort = addr.getPort();
        int rmiRegistryPort = this.getRmiRegistryPort();
        if (rmiRegHostName == null) {
            rmiRegHostName = brokerHostName;
        } else {
            try {
                rmiRegHostName = MQAddress.getMQAddress(rmiRegHostName, rmiRegistryPort).getHostName();
            }
            catch (MalformedURLException e) {
                throw new BrokerException(e.toString(), e);
            }
        }
        String ret = "/jndi/rmi://" + rmiRegHostName + ":" + Integer.toString(rmiRegistryPort) + "/" + brokerHostName + "/" + Integer.toString(brokerPort) + "/";
        return ret;
    }

    private MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer();
    }

    private boolean platformMBeanServerAvailable() {
        try {
            Class.forName("java.lang.management.ManagementFactory");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean jmxSupportEnabled() {
        return this.config.getBooleanProperty(ENABLED, true);
    }

    private boolean usePlatformMBeanServer() {
        return this.config.getBooleanProperty(USE_PLATFORM_MBEANSERVER);
    }

    private void agentRegisterMBean(Object mbean, ObjectName objName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.mbs == null) {
            return;
        }
        if (!this.mbs.isRegistered(objName)) {
            this.mbs.registerMBean(mbean, objName);
            if (DEBUG) {
                this.logger.log(4, "Registered MBean: " + objName.toString());
            }
            this.addMBean(mbean, objName);
        }
    }

    private void agentUnregisterMBean(ObjectName objName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.mbs == null) {
            return;
        }
        if (this.mbs.isRegistered(objName)) {
            this.mbs.unregisterMBean(objName);
            if (DEBUG) {
                this.logger.log(4, "Unregistered MBean: " + objName.toString());
            }
            this.removeMBean(objName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentUnregisterAllMBeans() throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.mbs == null) {
            return;
        }
        Map map = this.mbeans;
        synchronized (map) {
            Set objNames = this.mbeans.keySet();
            ObjectName[] objNamesArray = objNames.toArray(new ObjectName[objNames.size()]);
            for (int i = 0; i < objNamesArray.length; ++i) {
                this.agentUnregisterMBean(objNamesArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMBean(Object mbean, ObjectName objName) {
        Map map = this.mbeans;
        synchronized (map) {
            this.mbeans.put(objName, mbean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMBean(ObjectName objName) {
        Map map = this.mbeans;
        synchronized (map) {
            this.mbeans.remove(objName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMBean(ObjectName objName) {
        Object o = null;
        Map map = this.mbeans;
        synchronized (map) {
            o = this.mbeans.get(objName);
        }
        return o;
    }

    class ClusterStateListener
    implements ClusterListener {
        ClusterStateListener() {
        }

        @Override
        public void clusterPropertyChanged(String name, String value) {
        }

        @Override
        public void brokerAdded(ClusteredBroker broker, UID brokerSession) {
        }

        @Override
        public void brokerRemoved(ClusteredBroker broker, UID brokerSession) {
        }

        @Override
        public void masterBrokerChanged(ClusteredBroker oldMaster, ClusteredBroker newMaster) {
        }

        @Override
        public void brokerStatusChanged(String brokerid, int oldStatus, int newStatus, UID brokerSession, Object userData) {
            if (BrokerStatus.getBrokerIsUp(newStatus) && BrokerStatus.getBrokerIsDown(oldStatus)) {
                Agent.this.notifyClusterBrokerJoin(brokerid);
            }
            if (BrokerStatus.getBrokerIsDown(newStatus) && BrokerStatus.getBrokerIsUp(oldStatus)) {
                Agent.this.notifyClusterBrokerDown(brokerid);
            }
        }

        @Override
        public void brokerStateChanged(String brokerid, BrokerState oldState, BrokerState newState) {
            String takeoverBrokerID;
            if (!Globals.getHAEnabled()) {
                return;
            }
            String localBrokerID = Globals.getBrokerID();
            if ((newState == BrokerState.FAILOVER_PENDING || newState == BrokerState.FAILOVER_STARTED) && oldState != BrokerState.FAILOVER_PENDING && oldState != BrokerState.FAILOVER_STARTED) {
                takeoverBrokerID = this.getTakeoverBrokerID(brokerid);
                if (takeoverBrokerID == null || !takeoverBrokerID.equals(localBrokerID)) {
                    return;
                }
                Agent.this.notifyTakeoverStart(brokerid);
            }
            if (newState == BrokerState.FAILOVER_COMPLETE && oldState != BrokerState.FAILOVER_COMPLETE) {
                takeoverBrokerID = this.getTakeoverBrokerID(brokerid);
                if (takeoverBrokerID == null || !takeoverBrokerID.equals(localBrokerID)) {
                    return;
                }
                Agent.this.notifyTakeoverComplete(brokerid);
            }
            if (newState == BrokerState.FAILOVER_FAILED && oldState != BrokerState.FAILOVER_FAILED) {
                takeoverBrokerID = this.getTakeoverBrokerID(brokerid);
                if (takeoverBrokerID == null || !takeoverBrokerID.equals(localBrokerID)) {
                    return;
                }
                Agent.this.notifyTakeoverFail(brokerid);
            }
        }

        private String getTakeoverBrokerID(String failoverBrokerID) {
            ClusterManager cm = Globals.getClusterManager();
            if (cm == null) {
                return null;
            }
            ClusteredBroker cb = cm.getBroker(failoverBrokerID);
            if (cb == null) {
                return null;
            }
            Hashtable bkrInfo = GetClusterHandler.getBrokerClusterInfo(cb, Agent.this.logger);
            if (bkrInfo == null) {
                return null;
            }
            String takeoverBrokerID = (String)bkrInfo.get("TakeoverBrokerID");
            return takeoverBrokerID;
        }

        @Override
        public void brokerVersionChanged(String brokerid, int oldVersion, int newVersion) {
        }

        @Override
        public void brokerURLChanged(String brokerid, MQAddress oldAddress, MQAddress newAddress) {
        }
    }
}

