/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.style.Styler;

public class ChartImage
implements ChartPart {
    protected XChartPanel chartPanel;
    protected Chart chart;
    protected Rectangle bounds;
    protected boolean visible = true;
    protected Color fontColor;
    protected Font textFont;
    protected double xValue;
    protected double yValue;
    protected boolean valueInScreenCoordinate = false;
    protected Image image;
    int startx;
    int starty;

    public ChartImage(Image image, double xValue, double yValue, boolean valueInScreenCoordinate) {
        this.image = image;
        this.xValue = xValue;
        this.yValue = yValue;
        this.valueInScreenCoordinate = valueInScreenCoordinate;
    }

    public void init(XChartPanel<XYChart> chartPanel) {
        this.chartPanel = chartPanel;
        this.chart = chartPanel.getChart();
        if (this.fontColor == null) {
            this.fontColor = ((Styler)this.chart.getStyler()).getChartFontColor();
        }
        if (this.textFont == null) {
            this.textFont = ((Styler)this.chart.getStyler()).getLegendFont();
        }
        this.chart.addPlotPart(this);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    protected void calculatePosition() {
        if (this.valueInScreenCoordinate) {
            this.startx = (int)this.xValue;
            this.starty = (int)this.yValue;
        } else {
            this.startx = (int)(this.chart.getScreenXFromChart(this.xValue) + 0.5) - this.image.getWidth(null) / 2;
            this.starty = (int)(this.chart.getScreenYFromChart(this.yValue) + 0.5) - this.image.getHeight(null) / 2;
        }
    }

    @Override
    public void paint(Graphics2D g) {
        if (!this.visible) {
            return;
        }
        this.bounds = g.getClipBounds();
        this.calculatePosition();
        g.drawImage(this.image, this.startx, this.starty, null);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public double getxValue() {
        return this.xValue;
    }

    public void setxValue(double xValue) {
        this.xValue = xValue;
    }

    public double getyValue() {
        return this.yValue;
    }

    public void setyValue(double yValue) {
        this.yValue = yValue;
    }

    public boolean isValueInScreenCoordinate() {
        return this.valueInScreenCoordinate;
    }

    public void setValueInScreenCoordinate(boolean valueInScreenCoordinate) {
        this.valueInScreenCoordinate = valueInScreenCoordinate;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }
}

