/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class Archives {
    public static File tar(File baseDir, String archivePath) throws IOException {
        return Archives.tar(baseDir, new File(archivePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File tar(File baseDir, File tarFile) throws IOException {
        Preconditions.checkArgument((boolean)baseDir.isDirectory(), (String)"%s is not a directory", (Object[])new Object[]{baseDir});
        File[] files = baseDir.listFiles();
        String token = (String)Iterables.getLast((Iterable)Splitter.on((String)"/").split((CharSequence)baseDir.getAbsolutePath()));
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(tarFile));
        tos.setLongFileMode(2);
        try {
            for (File file : files) {
                TarArchiveEntry tarEntry = new TarArchiveEntry(file);
                tarEntry.setName("/" + (String)Iterables.getLast((Iterable)Splitter.on((String)token).split((CharSequence)file.toString())));
                tos.putArchiveEntry((ArchiveEntry)tarEntry);
                if (!file.isDirectory()) {
                    Files.asByteSource((File)file).copyTo((OutputStream)tos);
                }
                tos.closeArchiveEntry();
            }
        }
        finally {
            tos.close();
        }
        return tarFile;
    }
}

