/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.docker.binders.BindInputStreamToRequest;
import org.jclouds.docker.domain.Config;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.HostConfig;
import org.jclouds.docker.domain.Image;
import org.jclouds.docker.domain.Version;
import org.jclouds.docker.options.BuildOptions;
import org.jclouds.docker.options.CommitOptions;
import org.jclouds.docker.options.CreateImageOptions;
import org.jclouds.docker.options.DeleteImageOptions;
import org.jclouds.docker.options.ListContainerOptions;
import org.jclouds.docker.options.ListImageOptions;
import org.jclouds.docker.options.RemoveContainerOptions;
import org.jclouds.io.Payload;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.binders.BindToJsonPayload;

@Consumes(value={"application/json"})
public interface RemoteApi
extends Closeable {
    @Named(value="version")
    @GET
    @Path(value="/version")
    public Version getVersion();

    @Named(value="containers:list")
    @GET
    @Path(value="/containers/json")
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Container> listContainers();

    @Named(value="containers:list")
    @GET
    @Path(value="/containers/json")
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Container> listContainers(ListContainerOptions var1);

    @Named(value="container:create")
    @POST
    @Path(value="/containers/create")
    public Container createContainer(@QueryParam(value="name") String var1, @BinderParam(value=BindToJsonPayload.class) Config var2);

    @Named(value="container:inspect")
    @GET
    @Path(value="/containers/{id}/json")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Container inspectContainer(@PathParam(value="id") String var1);

    @Named(value="container:delete")
    @DELETE
    @Path(value="/containers/{id}")
    public void removeContainer(@PathParam(value="id") String var1);

    @Named(value="container:delete")
    @DELETE
    @Path(value="/containers/{id}")
    public void removeContainer(@PathParam(value="id") String var1, RemoveContainerOptions var2);

    @Named(value="container:start")
    @POST
    @Path(value="/containers/{id}/start")
    public void startContainer(@PathParam(value="id") String var1);

    @Named(value="container:start")
    @POST
    @Path(value="/containers/{id}/start")
    public void startContainer(@PathParam(value="id") String var1, @BinderParam(value=BindToJsonPayload.class) HostConfig var2);

    @Named(value="container:stop")
    @POST
    @Path(value="/containers/{id}/stop")
    public void stopContainer(@PathParam(value="id") String var1);

    @Named(value="container:commit")
    @POST
    @Path(value="/commit")
    public Image commit(CommitOptions var1);

    @Named(value="images:list")
    @GET
    @Path(value="/images/json")
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Image> listImages();

    @Named(value="images:list")
    @GET
    @Path(value="/images/json")
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Image> listImages(ListImageOptions var1);

    @Named(value="image:inspect")
    @GET
    @Path(value="/images/{name}/json")
    public Image inspectImage(@PathParam(value="name") String var1);

    @Named(value="image:create")
    @POST
    @Path(value="/images/create")
    public InputStream createImage(CreateImageOptions var1);

    @Named(value="image:delete")
    @DELETE
    @Path(value="/images/{name}")
    public InputStream deleteImage(@PathParam(value="name") String var1);

    @Named(value="image:delete")
    @DELETE
    @Path(value="/images/{name}")
    public InputStream deleteImage(@PathParam(value="name") String var1, DeleteImageOptions var2);

    @Named(value="image:build")
    @POST
    @Path(value="/build")
    @Headers(keys={"Content-Type"}, values={"application/tar"})
    public InputStream build(Payload var1, BuildOptions var2);

    @Named(value="image:build")
    @POST
    @Path(value="/build")
    @Headers(keys={"Content-Type"}, values={"application/tar"})
    public InputStream build(@BinderParam(value=BindInputStreamToRequest.class) File var1, BuildOptions var2);
}

