/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;

public class Version {
    @SerializedName(value="Arch")
    private final String arch;
    @SerializedName(value="GitCommit")
    private final String gitCommit;
    @SerializedName(value="GoVersion")
    private final String goVersion;
    @SerializedName(value="KernelVersion")
    private final String kernelVersion;
    @SerializedName(value="Os")
    private final String os;
    @SerializedName(value="Version")
    private final String version;

    @ConstructorProperties(value={"Arch", "GitCommit", "GoVersion", "KernelVersion", "Os", "Version"})
    protected Version(String arch, String gitCommit, String goVersion, String kernelVersion, String os, String version) {
        this.arch = (String)Preconditions.checkNotNull((Object)arch, (Object)"arch");
        this.gitCommit = (String)Preconditions.checkNotNull((Object)gitCommit, (Object)"gitCommit");
        this.goVersion = (String)Preconditions.checkNotNull((Object)goVersion, (Object)"goVersion");
        this.kernelVersion = (String)Preconditions.checkNotNull((Object)kernelVersion, (Object)"kernelVersion");
        this.os = (String)Preconditions.checkNotNull((Object)os, (Object)"os");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
    }

    public String getArch() {
        return this.arch;
    }

    public String getGitCommit() {
        return this.gitCommit;
    }

    public String getGoVersion() {
        return this.goVersion;
    }

    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public String getOs() {
        return this.os;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        return Objects.equal((Object)this.arch, (Object)that.arch) && Objects.equal((Object)this.gitCommit, (Object)that.gitCommit) && Objects.equal((Object)this.goVersion, (Object)that.goVersion) && Objects.equal((Object)this.kernelVersion, (Object)that.kernelVersion) && Objects.equal((Object)this.os, (Object)that.os) && Objects.equal((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.arch, this.gitCommit, this.goVersion, this.kernelVersion, this.os, this.version});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("arch", (Object)this.arch).add("gitCommit", (Object)this.gitCommit).add("goVersion", (Object)this.goVersion).add("kernelVersion", (Object)this.kernelVersion).add("os", (Object)this.os).add("version", (Object)this.version).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Version.builder().fromVersion(this);
    }

    public static final class Builder {
        private String arch;
        private String gitCommit;
        private String goVersion;
        private String kernelVersion;
        private String os;
        private String version;

        public Builder arch(String arch) {
            this.arch = arch;
            return this;
        }

        public Builder gitCommit(String gitCommit) {
            this.gitCommit = gitCommit;
            return this;
        }

        public Builder goVersion(String goVersion) {
            this.goVersion = goVersion;
            return this;
        }

        public Builder kernelVersion(String kernelVersion) {
            this.kernelVersion = kernelVersion;
            return this;
        }

        public Builder os(String os) {
            this.os = os;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Version build() {
            return new Version(this.arch, this.gitCommit, this.goVersion, this.kernelVersion, this.os, this.version);
        }

        public Builder fromVersion(Version in) {
            return this.arch(in.getArch()).gitCommit(in.getGitCommit()).goVersion(in.getGoVersion()).kernelVersion(in.getKernelVersion()).os(in.getOs()).version(in.getVersion());
        }
    }
}

