/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;

public class Port {
    @SerializedName(value="PrivatePort")
    private final int privatePort;
    @SerializedName(value="PublicPort")
    private final int publicPort;
    @SerializedName(value="Type")
    private final String type;
    @SerializedName(value="IP")
    private final String ip;

    @ConstructorProperties(value={"PrivatePort", "PublicPort", "Type", "IP"})
    protected Port(int privatePort, int publicPort, String type, String ip) {
        this.privatePort = (Integer)Preconditions.checkNotNull((Object)privatePort, (Object)"privatePort");
        this.publicPort = (Integer)Preconditions.checkNotNull((Object)publicPort, (Object)"publicPort");
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.ip = (String)Preconditions.checkNotNull((Object)ip, (Object)"ip");
    }

    public int getPrivatePort() {
        return this.privatePort;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public String getType() {
        return this.type;
    }

    public String getIp() {
        return this.ip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Port that = (Port)o;
        return Objects.equal((Object)this.privatePort, (Object)that.privatePort) && Objects.equal((Object)this.publicPort, (Object)that.publicPort) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.ip, (Object)that.ip);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.privatePort, this.publicPort, this.type, this.ip});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("privatePort", this.privatePort).add("publicPort", this.publicPort).add("type", (Object)this.type).add("ip", (Object)this.ip).toString();
    }
}

