/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

public class HostConfig {
    @SerializedName(value="ContainerIDFile")
    private final String containerIDFile;
    @SerializedName(value="Binds")
    private final List<String> binds;
    @SerializedName(value="LxcConf")
    private final Map<String, String> lxcConf;
    @SerializedName(value="Privileged")
    private final boolean privileged;
    @SerializedName(value="Dns")
    private final String dns;
    @SerializedName(value="DnsSearch")
    private final String dnsSearch;
    @SerializedName(value="PortBindings")
    private final Map<String, List<Map<String, String>>> portBindings;
    @SerializedName(value="Links")
    private final List<String> links;
    @SerializedName(value="PublishAllPorts")
    private final boolean publishAllPorts;
    @SerializedName(value="VolumesFrom")
    private final List<String> volumesFrom;

    @ConstructorProperties(value={"ContainerIDFile", "Binds", "LxcConf", "Privileged", "Dns", "DnsSearch", "PortBindings", "Links", "PublishAllPorts", "VolumesFrom"})
    protected HostConfig(@Nullable String containerIDFile, @Nullable List<String> binds, Map<String, String> lxcConf, boolean privileged, @Nullable String dns, @Nullable String dnsSearch, @Nullable Map<String, List<Map<String, String>>> portBindings, @Nullable List<String> links, boolean publishAllPorts, @Nullable List<String> volumesFrom) {
        this.containerIDFile = containerIDFile;
        this.binds = binds != null ? ImmutableList.copyOf(binds) : ImmutableList.of();
        this.lxcConf = lxcConf != null ? ImmutableMap.copyOf(lxcConf) : ImmutableMap.of();
        this.privileged = (Boolean)Preconditions.checkNotNull((Object)privileged, (Object)"privileged");
        this.dns = dns;
        this.dnsSearch = dnsSearch;
        this.portBindings = portBindings != null ? ImmutableMap.copyOf(portBindings) : ImmutableMap.of();
        this.links = links != null ? ImmutableList.copyOf(links) : ImmutableList.of();
        this.publishAllPorts = (Boolean)Preconditions.checkNotNull((Object)publishAllPorts, (Object)"publishAllPorts");
        this.volumesFrom = volumesFrom != null ? ImmutableList.copyOf(volumesFrom) : ImmutableList.of();
    }

    public String getContainerIDFile() {
        return this.containerIDFile;
    }

    public List<String> getBinds() {
        return this.binds;
    }

    public Map<String, String> getLxcConf() {
        return this.lxcConf;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    public String getDns() {
        return this.dns;
    }

    public String getDnsSearch() {
        return this.dnsSearch;
    }

    public Map<String, List<Map<String, String>>> getPortBindings() {
        return this.portBindings;
    }

    @Nullable
    public List<String> getLinks() {
        return this.links;
    }

    public boolean isPublishAllPorts() {
        return this.publishAllPorts;
    }

    public List<String> getVolumesFrom() {
        return this.volumesFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostConfig that = (HostConfig)o;
        return Objects.equal((Object)this.containerIDFile, (Object)that.containerIDFile) && Objects.equal(this.binds, that.binds) && Objects.equal(this.lxcConf, that.lxcConf) && Objects.equal((Object)this.privileged, (Object)that.privileged) && Objects.equal((Object)this.dns, (Object)that.dns) && Objects.equal((Object)this.dnsSearch, (Object)that.dnsSearch) && Objects.equal(this.portBindings, that.portBindings) && Objects.equal(this.links, that.links) && Objects.equal((Object)this.publishAllPorts, (Object)that.publishAllPorts) && Objects.equal(this.volumesFrom, that.volumesFrom);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.containerIDFile, this.binds, this.lxcConf, this.privileged, this.dns, this.dnsSearch, this.portBindings, this.links, this.publishAllPorts, this.volumesFrom});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("containerIDFile", (Object)this.containerIDFile).add("binds", this.binds).add("lxcConf", this.lxcConf).add("privileged", this.privileged).add("dns", (Object)this.dns).add("dnsSearch", (Object)this.dnsSearch).add("portBindings", this.portBindings).add("links", this.links).add("publishAllPorts", this.publishAllPorts).add("volumesFrom", this.volumesFrom).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return HostConfig.builder().fromHostConfig(this);
    }

    public static final class Builder {
        private String containerIDFile;
        private List<String> binds = Lists.newArrayList();
        private Map<String, String> lxcConf = Maps.newLinkedHashMap();
        private boolean privileged;
        private String dns;
        private String dnsSearch;
        private Map<String, List<Map<String, String>>> portBindings = Maps.newLinkedHashMap();
        private List<String> links = Lists.newArrayList();
        private boolean publishAllPorts;
        private List<String> volumesFrom = Lists.newArrayList();

        public Builder containerIDFile(String containerIDFile) {
            this.containerIDFile = containerIDFile;
            return this;
        }

        public Builder binds(List<String> binds) {
            this.binds.addAll((Collection)Preconditions.checkNotNull(binds, (Object)"binds"));
            return this;
        }

        public Builder lxcConf(Map<String, String> lxcConf) {
            this.lxcConf.putAll((Map)Preconditions.checkNotNull(lxcConf, (Object)"lxcConf"));
            return this;
        }

        public Builder privileged(boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public Builder dns(String dns) {
            this.dns = dns;
            return this;
        }

        public Builder dnsSearch(String dnsSearch) {
            this.dnsSearch = dnsSearch;
            return this;
        }

        public Builder links(List<String> links) {
            this.links.addAll((Collection)Preconditions.checkNotNull(links, (Object)"links"));
            return this;
        }

        public Builder portBindings(Map<String, List<Map<String, String>>> portBindings) {
            this.portBindings.putAll(portBindings);
            return this;
        }

        public Builder publishAllPorts(boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        public Builder volumesFrom(List<String> volumesFrom) {
            this.volumesFrom.addAll((Collection)Preconditions.checkNotNull(volumesFrom, (Object)"volumesFrom"));
            return this;
        }

        public HostConfig build() {
            return new HostConfig(this.containerIDFile, this.binds, this.lxcConf, this.privileged, this.dns, this.dnsSearch, this.portBindings, this.links, this.publishAllPorts, this.volumesFrom);
        }

        public Builder fromHostConfig(HostConfig in) {
            return this.containerIDFile(in.getContainerIDFile()).binds(in.getBinds()).lxcConf(in.getLxcConf()).privileged(in.isPrivileged()).dns(in.getDns()).dnsSearch(in.getDnsSearch()).links(in.getLinks()).portBindings(in.getPortBindings()).publishAllPorts(in.isPublishAllPorts()).volumesFrom(in.getVolumesFrom());
        }
    }
}

