/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import org.jclouds.docker.domain.Config;
import org.jclouds.docker.domain.HostConfig;
import org.jclouds.docker.domain.NetworkSettings;
import org.jclouds.docker.domain.Port;
import org.jclouds.docker.domain.State;
import org.jclouds.javax.annotation.Nullable;

public class Container {
    @SerializedName(value="Id")
    private final String id;
    @SerializedName(value="Name")
    private final String name;
    @SerializedName(value="Created")
    private final String created;
    @SerializedName(value="Path")
    private final String path;
    @SerializedName(value="Args")
    private final String[] args;
    @SerializedName(value="Config")
    private final Config containerConfig;
    @SerializedName(value="State")
    private final State state;
    @SerializedName(value="Image")
    private final String image;
    @SerializedName(value="NetworkSettings")
    private final NetworkSettings networkSettings;
    @SerializedName(value="ResolvConfPath")
    private final String resolvConfPath;
    @SerializedName(value="Driver")
    private final String driver;
    @SerializedName(value="ExecDriver")
    private final String execDriver;
    @SerializedName(value="Volumes")
    private final Map<String, String> volumes;
    @SerializedName(value="VolumesRW")
    private final Map<String, Boolean> volumesRW;
    @SerializedName(value="Command")
    private final String command;
    @SerializedName(value="Status")
    private final String status;
    @SerializedName(value="HostConfig")
    private final HostConfig hostConfig;
    @SerializedName(value="Ports")
    private final List<Port> ports;
    @SerializedName(value="HostnamePath")
    private final String hostnamePath;

    @ConstructorProperties(value={"Id", "Name", "Created", "Path", "Args", "Config", "State", "Image", "NetworkSettings", "ResolvConfPath", "Driver", "ExecDriver", "Volumes", "VolumesRW", "Command", "Status", "HostConfig", "Ports", "HostnamePath"})
    protected Container(String id, @Nullable String name, @Nullable String created, @Nullable String path, @Nullable String[] args, @Nullable Config containerConfig, @Nullable State state, @Nullable String image, @Nullable NetworkSettings networkSettings, @Nullable String resolvConfPath, @Nullable String driver, @Nullable String execDriver, @Nullable Map<String, String> volumes, @Nullable Map<String, Boolean> volumesRW, @Nullable String command, @Nullable String status, @Nullable HostConfig hostConfig, @Nullable List<Port> ports, @Nullable String hostnamePath) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = name;
        this.created = created;
        this.path = path;
        this.args = args;
        this.containerConfig = containerConfig;
        this.state = state;
        this.image = image;
        this.networkSettings = networkSettings;
        this.resolvConfPath = resolvConfPath;
        this.driver = driver;
        this.execDriver = execDriver;
        this.volumes = volumes != null ? ImmutableMap.copyOf(volumes) : ImmutableMap.of();
        this.volumesRW = volumesRW != null ? ImmutableMap.copyOf(volumesRW) : ImmutableMap.of();
        this.command = command;
        this.status = status;
        this.hostConfig = hostConfig;
        this.ports = ports != null ? ImmutableList.copyOf(ports) : ImmutableList.of();
        this.hostnamePath = hostnamePath;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCreated() {
        return this.created;
    }

    public String getPath() {
        return this.path;
    }

    public String[] getArgs() {
        return this.args;
    }

    public Config getContainerConfig() {
        return this.containerConfig;
    }

    public State getState() {
        return this.state;
    }

    public String getImage() {
        return this.image;
    }

    public NetworkSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public String getResolvConfPath() {
        return this.resolvConfPath;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getExecDriver() {
        return this.execDriver;
    }

    public Map<String, String> getVolumes() {
        return this.volumes;
    }

    public Map<String, Boolean> getvolumesRW() {
        return this.volumesRW;
    }

    public String getCommand() {
        return this.command;
    }

    public String getStatus() {
        return this.status;
    }

    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    public List<Port> getPorts() {
        return this.ports;
    }

    public String getHostnamePath() {
        return this.hostnamePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Container that = (Container)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.path, (Object)that.path) && Objects.equal((Object)this.args, (Object)that.args) && Objects.equal((Object)this.containerConfig, (Object)that.containerConfig) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal((Object)this.image, (Object)that.image) && Objects.equal((Object)this.networkSettings, (Object)that.networkSettings) && Objects.equal((Object)this.resolvConfPath, (Object)that.resolvConfPath) && Objects.equal((Object)this.driver, (Object)that.driver) && Objects.equal((Object)this.execDriver, (Object)that.execDriver) && Objects.equal(this.volumes, that.volumes) && Objects.equal(this.volumesRW, that.volumesRW) && Objects.equal((Object)this.command, (Object)that.command) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal((Object)this.hostConfig, (Object)that.hostConfig) && Objects.equal(this.ports, that.ports) && Objects.equal((Object)this.hostnamePath, (Object)that.hostnamePath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.created, this.path, this.args, this.containerConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.driver, this.execDriver, this.volumes, this.volumesRW, this.command, this.status, this.hostConfig, this.ports, this.hostnamePath});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("created", (Object)this.created).add("path", (Object)this.path).add("args", (Object)this.args).add("containerConfig", (Object)this.containerConfig).add("state", (Object)this.state).add("image", (Object)this.image).add("networkSettings", (Object)this.networkSettings).add("resolvConfPath", (Object)this.resolvConfPath).add("driver", (Object)this.driver).add("execDriver", (Object)this.execDriver).add("volumes", this.volumes).add("volumesRW", this.volumesRW).add("command", (Object)this.command).add("status", (Object)this.status).add("hostConfig", (Object)this.hostConfig).add("ports", this.ports).add("hostnamePath", (Object)this.hostnamePath).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Container.builder().fromContainer(this);
    }

    public static final class Builder {
        private String id;
        private String name;
        private String created;
        private String path;
        private String[] args;
        private Config containerConfig;
        private State state;
        private String image;
        private NetworkSettings networkSettings;
        private String resolvConfPath;
        private String driver;
        private String execDriver;
        private Map<String, String> volumes = ImmutableMap.of();
        private Map<String, Boolean> volumesRW = ImmutableMap.of();
        private String command;
        private String status;
        private HostConfig hostConfig;
        private List<Port> ports = ImmutableList.of();
        private String hostnamePath;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder created(String created) {
            this.created = created;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder args(String[] args) {
            this.args = args;
            return this;
        }

        public Builder containerConfig(Config containerConfig) {
            this.containerConfig = containerConfig;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder image(String imageName) {
            this.image = imageName;
            return this;
        }

        public Builder networkSettings(NetworkSettings networkSettings) {
            this.networkSettings = networkSettings;
            return this;
        }

        public Builder resolvConfPath(String resolvConfPath) {
            this.resolvConfPath = resolvConfPath;
            return this;
        }

        public Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        public Builder execDriver(String execDriver) {
            this.execDriver = execDriver;
            return this;
        }

        public Builder volumes(Map<String, String> volumes) {
            this.volumes = volumes;
            return this;
        }

        public Builder volumesRW(Map<String, Boolean> volumesRW) {
            this.volumesRW = volumesRW;
            return this;
        }

        public Builder command(String command) {
            this.command = command;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder hostConfig(HostConfig hostConfig) {
            this.hostConfig = hostConfig;
            return this;
        }

        public Builder ports(List<Port> ports) {
            this.ports = ports;
            return this;
        }

        public Builder hostnamePath(String hostnamePath) {
            this.hostnamePath = hostnamePath;
            return this;
        }

        public Container build() {
            return new Container(this.id, this.name, this.created, this.path, this.args, this.containerConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.driver, this.execDriver, this.volumes, this.volumesRW, this.command, this.status, this.hostConfig, this.ports, this.hostnamePath);
        }

        public Builder fromContainer(Container in) {
            return this.id(in.getId()).name(in.getName()).created(in.getCreated()).path(in.getPath()).args(in.getArgs()).containerConfig(in.getContainerConfig()).state(in.getState()).image(in.getImage()).networkSettings(in.getNetworkSettings()).resolvConfPath(in.getResolvConfPath()).driver(in.getDriver()).execDriver(in.getExecDriver()).volumes(in.getVolumes()).volumesRW(in.getvolumesRW()).command(in.getCommand()).status(in.getStatus()).hostConfig(in.getHostConfig()).ports(in.getPorts()).hostnamePath(in.getHostnamePath());
        }
    }
}

