/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.docker.features.internal.Archives;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.logging.Logger;
import org.jclouds.rest.Binder;

@Singleton
public class BindInputStreamToRequest
implements Binder {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof File), (Object)"this binder is only valid for File!");
        Preconditions.checkNotNull(request, (Object)"request");
        File dockerFile = (File)input;
        File tmpDir = Files.createTempDir();
        File targetFile = new File(tmpDir + File.separator + "Dockerfile");
        try {
            Files.copy((File)dockerFile, (File)targetFile);
            File archive = Archives.tar(tmpDir, File.createTempFile("archive", ".tar"));
            FileInputStream data = new FileInputStream(archive);
            InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)data);
            payload.getContentMetadata().setContentLength(Long.valueOf(data.getChannel().size()));
            payload.getContentMetadata().setContentType("application/tar");
            request.setPayload((Payload)payload);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "Couldn't create a tarball for %s", new Object[]{targetFile});
            throw Throwables.propagate((Throwable)e);
        }
        return request;
    }
}

