/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cim;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.cim.ManagedElement;

public class VirtualSystemSettingData
extends ManagedElement {
    private final AutomaticRecoveryAction automaticRecoveryAction;
    private final AutomaticShutdownAction automaticShutdownAction;
    private final AutomaticStartupAction automaticStartupAction;
    private final Long automaticStartupActionDelay;
    private final Integer automaticStartupActionSequenceNumber;
    private final URI configurationDataRoot;
    private final URI configurationFile;
    private final String configurationID;
    private final Date creationTime;
    private final URI logDataRoot;
    private final URI recoveryFile;
    private final URI snapshotDataRoot;
    private final URI suspendDataRoot;
    private final URI swapFileDataRoot;
    private final String virtualSystemIdentifier;
    private final Set<String> virtualSystemTypes;
    private final String notes;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return VirtualSystemSettingData.builder().fromVirtualSystemSettingData(this);
    }

    public VirtualSystemSettingData(String elementName, String instanceID, String caption, String description, AutomaticRecoveryAction automaticRecoveryAction, AutomaticShutdownAction automaticShutdownAction, AutomaticStartupAction automaticStartupAction, Long automaticStartupActionDelay, Integer automaticStartupActionSequenceNumber, URI configurationDataRoot, URI configurationFile, String configurationID, Date creationTime, URI logDataRoot, URI recoveryFile, URI snapshotDataRoot, URI suspendDataRoot, URI swapFileDataRoot, String virtualSystemIdentifier, Iterable<String> virtualSystemTypes, String notes) {
        super(elementName, instanceID, caption, description);
        this.automaticRecoveryAction = automaticRecoveryAction;
        this.automaticShutdownAction = automaticShutdownAction;
        this.automaticStartupAction = automaticStartupAction;
        this.automaticStartupActionDelay = automaticStartupActionDelay;
        this.automaticStartupActionSequenceNumber = automaticStartupActionSequenceNumber;
        this.configurationDataRoot = configurationDataRoot;
        this.configurationFile = configurationFile;
        this.configurationID = configurationID;
        this.creationTime = creationTime;
        this.logDataRoot = logDataRoot;
        this.recoveryFile = recoveryFile;
        this.snapshotDataRoot = snapshotDataRoot;
        this.suspendDataRoot = suspendDataRoot;
        this.swapFileDataRoot = swapFileDataRoot;
        this.virtualSystemIdentifier = virtualSystemIdentifier;
        this.virtualSystemTypes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(virtualSystemTypes, (Object)"virtualSystemTypes")));
        this.notes = notes;
    }

    public AutomaticRecoveryAction getAutomaticRecoveryAction() {
        return this.automaticRecoveryAction;
    }

    public AutomaticShutdownAction getAutomaticShutdownAction() {
        return this.automaticShutdownAction;
    }

    public AutomaticStartupAction getAutomaticStartupAction() {
        return this.automaticStartupAction;
    }

    public Long getAutomaticStartupActionDelay() {
        return this.automaticStartupActionDelay;
    }

    public Integer getAutomaticStartupActionSequenceNumber() {
        return this.automaticStartupActionSequenceNumber;
    }

    public URI getConfigurationDataRoot() {
        return this.configurationDataRoot;
    }

    public URI getConfigurationFile() {
        return this.configurationFile;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public URI getLogDataRoot() {
        return this.logDataRoot;
    }

    public URI getRecoveryFile() {
        return this.recoveryFile;
    }

    public URI getSnapshotDataRoot() {
        return this.snapshotDataRoot;
    }

    public URI getSuspendDataRoot() {
        return this.suspendDataRoot;
    }

    public URI getSwapFileDataRoot() {
        return this.swapFileDataRoot;
    }

    public String getVirtualSystemIdentifier() {
        return this.virtualSystemIdentifier;
    }

    public Set<String> getVirtualSystemTypes() {
        return this.virtualSystemTypes;
    }

    public String getNotes() {
        return this.notes;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.virtualSystemIdentifier == null ? 0 : this.virtualSystemIdentifier.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualSystemSettingData other = (VirtualSystemSettingData)obj;
        return !(this.virtualSystemIdentifier == null ? other.virtualSystemIdentifier != null : !this.virtualSystemIdentifier.equals(other.virtualSystemIdentifier));
    }

    @Override
    public String toString() {
        return String.format("[elementName=%s, instanceID=%s, caption=%s, description=%s, automaticRecoveryAction=%s, automaticShutdownAction=%s, automaticStartupAction=%s, automaticStartupActionDelay=%s, automaticStartupActionSequenceNumber=%s, configurationDataRoot=%s, configurationFile=%s, configurationID=%s, creationTime=%s, logDataRoot=%s, notes=%s, recoveryFile=%s, snapshotDataRoot=%s, suspendDataRoot=%s, swapFileDataRoot=%s, virtualSystemIdentifier=%s, virtualSystemTypes=%s]", new Object[]{this.elementName, this.instanceID, this.caption, this.description, this.automaticRecoveryAction, this.automaticShutdownAction, this.automaticStartupAction, this.automaticStartupActionDelay, this.automaticStartupActionSequenceNumber, this.configurationDataRoot, this.configurationFile, this.configurationID, this.creationTime, this.logDataRoot, this.notes, this.recoveryFile, this.snapshotDataRoot, this.suspendDataRoot, this.swapFileDataRoot, this.virtualSystemIdentifier, this.virtualSystemTypes});
    }

    public static enum AutomaticRecoveryAction {
        NONE(2),
        RESTART(3),
        REVERT_TO_SNAPSHOT(4);

        protected final int code;
        protected static final Map<Integer, AutomaticRecoveryAction> AUTOMATIC_RECOVERY_ACTION_BY_ID;

        private AutomaticRecoveryAction(int code) {
            this.code = code;
        }

        public String value() {
            return this.code + "";
        }

        public static AutomaticRecoveryAction fromValue(String automaticRecoveryAction) {
            return AUTOMATIC_RECOVERY_ACTION_BY_ID.get(Integer.valueOf((String)Preconditions.checkNotNull((Object)automaticRecoveryAction, (Object)"automaticRecoveryAction")));
        }

        static {
            AUTOMATIC_RECOVERY_ACTION_BY_ID = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])AutomaticRecoveryAction.values()), (Function)new Function<AutomaticRecoveryAction, Integer>(){

                public Integer apply(AutomaticRecoveryAction input) {
                    return input.code;
                }
            });
        }
    }

    public static enum AutomaticShutdownAction {
        TURN_OFF(2),
        SAVE_STATE(3),
        SHUTDOWN(4);

        protected final int code;
        protected static final Map<Integer, AutomaticShutdownAction> AUTOMATIC_SHUTDOWN_ACTION_BY_ID;

        private AutomaticShutdownAction(int code) {
            this.code = code;
        }

        public String value() {
            return this.code + "";
        }

        public static AutomaticShutdownAction fromValue(String automaticShutdownAction) {
            return AUTOMATIC_SHUTDOWN_ACTION_BY_ID.get(Integer.valueOf((String)Preconditions.checkNotNull((Object)automaticShutdownAction, (Object)"automaticShutdownAction")));
        }

        static {
            AUTOMATIC_SHUTDOWN_ACTION_BY_ID = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])AutomaticShutdownAction.values()), (Function)new Function<AutomaticShutdownAction, Integer>(){

                public Integer apply(AutomaticShutdownAction input) {
                    return input.code;
                }
            });
        }
    }

    public static enum AutomaticStartupAction {
        NONE(2),
        RESTART_IF_PREVIOUSLY_ACTIVE(3),
        ALWAYS_STARTUP(4);

        protected final int code;
        protected static final Map<Integer, AutomaticStartupAction> AUTOMATIC_STARTUP_ACTION_BY_ID;

        private AutomaticStartupAction(int code) {
            this.code = code;
        }

        public String value() {
            return this.code + "";
        }

        public static AutomaticStartupAction fromValue(String automaticStartupAction) {
            return AUTOMATIC_STARTUP_ACTION_BY_ID.get(Integer.valueOf((String)Preconditions.checkNotNull((Object)automaticStartupAction, (Object)"automaticStartupAction")));
        }

        static {
            AUTOMATIC_STARTUP_ACTION_BY_ID = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])AutomaticStartupAction.values()), (Function)new Function<AutomaticStartupAction, Integer>(){

                public Integer apply(AutomaticStartupAction input) {
                    return input.code;
                }
            });
        }
    }

    public static class Builder
    extends ManagedElement.Builder {
        private AutomaticRecoveryAction automaticRecoveryAction;
        private AutomaticShutdownAction automaticShutdownAction;
        private AutomaticStartupAction automaticStartupAction;
        private Long automaticStartupActionDelay;
        private Integer automaticStartupActionSequenceNumber;
        private URI configurationDataRoot;
        private URI configurationFile;
        private String configurationID;
        private Date creationTime;
        private URI logDataRoot;
        private URI recoveryFile;
        private URI snapshotDataRoot;
        private URI suspendDataRoot;
        private URI swapFileDataRoot;
        private String virtualSystemIdentifier;
        private Set<String> virtualSystemTypes = Sets.newLinkedHashSet();
        private String notes;

        public Builder automaticRecoveryAction(AutomaticRecoveryAction automaticRecoveryAction) {
            this.automaticRecoveryAction = automaticRecoveryAction;
            return this;
        }

        public Builder automaticShutdownAction(AutomaticShutdownAction automaticShutdownAction) {
            this.automaticShutdownAction = automaticShutdownAction;
            return this;
        }

        public Builder automaticStartupAction(AutomaticStartupAction automaticStartupAction) {
            this.automaticStartupAction = automaticStartupAction;
            return this;
        }

        public Builder automaticStartupActionDelay(Long automaticStartupActionDelay) {
            this.automaticStartupActionDelay = automaticStartupActionDelay;
            return this;
        }

        public Builder automaticStartupActionSequenceNumber(Integer automaticStartupActionSequenceNumber) {
            this.automaticStartupActionSequenceNumber = automaticStartupActionSequenceNumber;
            return this;
        }

        public Builder configurationDataRoot(URI configurationDataRoot) {
            this.configurationDataRoot = configurationDataRoot;
            return this;
        }

        public Builder configurationFile(URI configurationFile) {
            this.configurationFile = configurationFile;
            return this;
        }

        public Builder configurationID(String configurationID) {
            this.configurationID = configurationID;
            return this;
        }

        public Builder creationTime(Date creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder logDataRoot(URI logDataRoot) {
            this.logDataRoot = logDataRoot;
            return this;
        }

        public Builder recoveryFile(URI recoveryFile) {
            this.recoveryFile = recoveryFile;
            return this;
        }

        public Builder snapshotDataRoot(URI snapshotDataRoot) {
            this.snapshotDataRoot = snapshotDataRoot;
            return this;
        }

        public Builder suspendDataRoot(URI suspendDataRoot) {
            this.suspendDataRoot = suspendDataRoot;
            return this;
        }

        public Builder swapFileDataRoot(URI swapFileDataRoot) {
            this.swapFileDataRoot = swapFileDataRoot;
            return this;
        }

        public Builder virtualSystemIdentifier(String virtualSystemIdentifier) {
            this.virtualSystemIdentifier = virtualSystemIdentifier;
            return this;
        }

        public Builder virtualSystemTypes(Iterable<String> virtualSystemTypes) {
            this.virtualSystemTypes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(virtualSystemTypes, (Object)"virtualSystemTypes")));
            return this;
        }

        public Builder virtualSystemType(String virtualSystemType) {
            this.virtualSystemTypes.add((String)Preconditions.checkNotNull((Object)virtualSystemType, (Object)"virtualSystemType"));
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public VirtualSystemSettingData build() {
            return new VirtualSystemSettingData(this.elementName, this.instanceID, this.caption, this.description, this.automaticRecoveryAction, this.automaticShutdownAction, this.automaticStartupAction, this.automaticStartupActionDelay, this.automaticStartupActionSequenceNumber, this.configurationDataRoot, this.configurationFile, this.configurationID, this.creationTime, this.logDataRoot, this.recoveryFile, this.snapshotDataRoot, this.suspendDataRoot, this.swapFileDataRoot, this.virtualSystemIdentifier, this.virtualSystemTypes, this.notes);
        }

        public Builder fromVirtualSystemSettingData(VirtualSystemSettingData in) {
            return this.fromManagedElement(in).automaticRecoveryAction(in.getAutomaticRecoveryAction()).automaticShutdownAction(in.getAutomaticShutdownAction()).automaticStartupAction(in.getAutomaticStartupAction()).automaticStartupActionDelay(in.getAutomaticStartupActionDelay()).automaticStartupActionSequenceNumber(in.getAutomaticStartupActionSequenceNumber()).configurationDataRoot(in.getConfigurationDataRoot()).configurationFile(in.getConfigurationFile()).configurationID(in.getConfigurationID()).creationTime(in.getCreationTime()).logDataRoot(in.getLogDataRoot()).recoveryFile(in.getRecoveryFile()).snapshotDataRoot(in.getSnapshotDataRoot()).suspendDataRoot(in.getSuspendDataRoot()).swapFileDataRoot(in.getSwapFileDataRoot()).virtualSystemIdentifier(in.getVirtualSystemIdentifier()).virtualSystemTypes(in.getVirtualSystemTypes()).notes(in.getNotes());
        }

        @Override
        public Builder fromManagedElement(ManagedElement in) {
            return (Builder)Builder.class.cast(super.fromManagedElement(in));
        }

        @Override
        public Builder caption(String caption) {
            return (Builder)Builder.class.cast(super.caption(caption));
        }

        @Override
        public Builder description(String description) {
            return (Builder)Builder.class.cast(super.description(description));
        }

        @Override
        public Builder elementName(String elementName) {
            return (Builder)Builder.class.cast(super.elementName(elementName));
        }

        @Override
        public Builder instanceID(String instanceID) {
            return (Builder)Builder.class.cast(super.instanceID(instanceID));
        }
    }
}

