/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.nova.v2_0.domain.Network;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateServerOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private String keyName;
    private String adminPass;
    private Set<String> securityGroupNames = ImmutableSet.of();
    private Map<String, String> metadata = ImmutableMap.of();
    private List<File> personality = Lists.newArrayList();
    private byte[] userData;
    private String diskConfig;
    private Set<String> networks = ImmutableSet.of();
    private Set<Network> novaNetworks = ImmutableSet.of();
    private String availabilityZone;
    private boolean configDrive;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CreateServerOptions) {
            CreateServerOptions other = (CreateServerOptions)CreateServerOptions.class.cast(object);
            return Objects.equal((Object)this.keyName, (Object)other.keyName) && Objects.equal(this.securityGroupNames, other.securityGroupNames) && Objects.equal(this.metadata, other.metadata) && Objects.equal(this.personality, other.personality) && Objects.equal((Object)this.adminPass, (Object)other.adminPass) && Objects.equal((Object)this.diskConfig, (Object)other.diskConfig) && Objects.equal((Object)this.adminPass, (Object)other.adminPass) && Objects.equal(this.networks, other.networks) && Objects.equal((Object)this.availabilityZone, (Object)other.availabilityZone) && Objects.equal((Object)this.configDrive, (Object)other.configDrive);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyName, this.securityGroupNames, this.metadata, this.personality, this.adminPass, this.networks, this.availabilityZone, this.configDrive});
    }

    protected Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = Objects.toStringHelper((String)"").omitNullValues();
        toString.add("keyName", (Object)this.keyName);
        if (this.securityGroupNames.size() > 0) {
            toString.add("securityGroupNames", this.securityGroupNames);
        }
        if (this.metadata.size() > 0) {
            toString.add("metadata", this.metadata);
        }
        if (this.personality.size() > 0) {
            toString.add("personality", this.personality);
        }
        if (this.adminPass != null) {
            toString.add("adminPassPresent", true);
        }
        if (this.diskConfig != null) {
            toString.add("diskConfig", (Object)this.diskConfig);
        }
        toString.add("userData", (Object)(this.userData == null ? null : new String(this.userData)));
        if (!this.networks.isEmpty()) {
            toString.add("networks", this.networks);
        }
        toString.add("availability_zone", (Object)(this.availabilityZone == null ? null : this.availabilityZone));
        toString.add("configDrive", this.configDrive);
        return toString;
    }

    public String toString() {
        return this.string().toString();
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ServerRequest server = new ServerRequest(Preconditions.checkNotNull((Object)postParams.get("name"), (Object)"name parameter not present").toString(), Preconditions.checkNotNull((Object)postParams.get("imageRef"), (Object)"imageRef parameter not present").toString(), Preconditions.checkNotNull((Object)postParams.get("flavorRef"), (Object)"flavorRef parameter not present").toString());
        if (this.metadata.size() > 0) {
            server.metadata = this.metadata;
        }
        if (this.personality.size() > 0) {
            server.personality = this.personality;
        }
        if (this.keyName != null) {
            server.key_name = this.keyName;
        }
        if (this.availabilityZone != null) {
            server.availabilityZone = this.availabilityZone;
        }
        if (this.userData != null) {
            server.user_data = BaseEncoding.base64().encode(this.userData);
        }
        if (this.configDrive) {
            server.configDrive = "true";
        }
        if (this.securityGroupNames.size() > 0) {
            server.securityGroupNames = Sets.newLinkedHashSet();
            for (String string : this.securityGroupNames) {
                server.securityGroupNames.add(new NamedThingy(string));
            }
        }
        if (this.adminPass != null) {
            server.adminPass = this.adminPass;
        }
        if (this.diskConfig != null) {
            server.diskConfig = this.diskConfig;
        }
        if (!this.networks.isEmpty() || !this.novaNetworks.isEmpty()) {
            server.networks = Sets.newLinkedHashSet();
            for (Network network : this.novaNetworks) {
                ImmutableMap.Builder networkMap = new ImmutableMap.Builder();
                if (network.getNetworkUuid() != null) {
                    networkMap.put((Object)"uuid", (Object)network.getNetworkUuid());
                }
                if (network.getPortUuid() != null) {
                    networkMap.put((Object)"port", (Object)network.getPortUuid());
                }
                if (network.getFixedIp() != null) {
                    networkMap.put((Object)"fixed_ip", (Object)network.getFixedIp());
                }
                server.networks.add((Map<String, String>)networkMap.build());
            }
            for (String string : this.networks) {
                server.networks.add((Map<String, String>)ImmutableMap.of((Object)"uuid", (Object)string));
            }
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"server", (Object)server));
    }

    public CreateServerOptions writeFileToPath(byte[] contents, String path) {
        Preconditions.checkState((this.personality.size() < 5 ? 1 : 0) != 0, (Object)"maximum number of files allowed is 5");
        this.personality.add(new File(path, contents));
        return this;
    }

    public CreateServerOptions adminPass(String adminPass) {
        Preconditions.checkNotNull((Object)adminPass, (Object)"adminPass");
        this.adminPass = adminPass;
        return this;
    }

    public CreateServerOptions metadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata, (Object)"metadata");
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            Preconditions.checkArgument((entry.getKey().getBytes().length < 255 ? 1 : 0) != 0, (Object)String.format("maximum length of metadata key is 255 bytes.  Key specified %s is %d bytes", entry.getKey(), entry.getKey().getBytes().length));
            Preconditions.checkArgument((entry.getKey().getBytes().length < 255 ? 1 : 0) != 0, (Object)String.format("maximum length of metadata value is 255 bytes.  Value specified for %s (%s) is %d bytes", entry.getKey(), entry.getValue(), entry.getValue().getBytes().length));
        }
        this.metadata = ImmutableMap.copyOf(metadata);
        return this;
    }

    public CreateServerOptions userData(byte[] userData) {
        this.userData = userData;
        return this;
    }

    public CreateServerOptions configDrive(boolean configDrive) {
        this.configDrive = configDrive;
        return this;
    }

    public String getKeyPairName() {
        return this.keyName;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public CreateServerOptions keyPairName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public CreateServerOptions availabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public Set<String> getSecurityGroupNames() {
        return this.securityGroupNames;
    }

    public Set<String> getNetworks() {
        return this.networks;
    }

    public Set<Network> getNovaNetworks() {
        return this.novaNetworks;
    }

    public CreateServerOptions securityGroupNames(String ... securityGroupNames) {
        return this.securityGroupNames((Iterable<String>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)securityGroupNames, (Object)"securityGroupNames"))));
    }

    public CreateServerOptions securityGroupNames(Iterable<String> securityGroupNames) {
        for (String groupName : (Iterable)Preconditions.checkNotNull(securityGroupNames, (Object)"securityGroupNames")) {
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)groupName), (Object)"all security groups must be non-empty");
        }
        this.securityGroupNames = ImmutableSet.copyOf(securityGroupNames);
        return this;
    }

    public String getDiskConfig() {
        return this.diskConfig;
    }

    public CreateServerOptions diskConfig(String diskConfig) {
        this.diskConfig = diskConfig;
        return this;
    }

    public boolean getConfigDrive() {
        return this.configDrive;
    }

    public CreateServerOptions networks(Iterable<String> networks) {
        this.networks = ImmutableSet.copyOf(networks);
        return this;
    }

    public CreateServerOptions novaNetworks(Iterable<Network> networks) {
        this.novaNetworks = ImmutableSet.copyOf(networks);
        return this;
    }

    public CreateServerOptions networks(String ... networks) {
        return this.networks((Iterable<String>)ImmutableSet.copyOf((Object[])networks));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static class Builder {
        public static CreateServerOptions writeFileToPath(byte[] contents, String path) {
            CreateServerOptions options = new CreateServerOptions();
            return options.writeFileToPath(contents, path);
        }

        public static CreateServerOptions adminPass(String adminPass) {
            CreateServerOptions options = new CreateServerOptions();
            return options.adminPass(adminPass);
        }

        public static CreateServerOptions metadata(Map<String, String> metadata) {
            CreateServerOptions options = new CreateServerOptions();
            return options.metadata(metadata);
        }

        public static CreateServerOptions keyPairName(String keyName) {
            CreateServerOptions options = new CreateServerOptions();
            return options.keyPairName(keyName);
        }

        public static CreateServerOptions securityGroupNames(String ... groupNames) {
            CreateServerOptions options = new CreateServerOptions();
            return (CreateServerOptions)CreateServerOptions.class.cast(options.securityGroupNames(groupNames));
        }

        public static CreateServerOptions securityGroupNames(Iterable<String> groupNames) {
            CreateServerOptions options = new CreateServerOptions();
            return (CreateServerOptions)CreateServerOptions.class.cast(options.securityGroupNames(groupNames));
        }

        public static CreateServerOptions diskConfig(String diskConfig) {
            CreateServerOptions options = new CreateServerOptions();
            return (CreateServerOptions)CreateServerOptions.class.cast(options.diskConfig(diskConfig));
        }

        public static CreateServerOptions networks(String ... networks) {
            CreateServerOptions options = new CreateServerOptions();
            return (CreateServerOptions)CreateServerOptions.class.cast(options.networks(networks));
        }

        public static CreateServerOptions networks(Iterable<String> networks) {
            CreateServerOptions options = new CreateServerOptions();
            return (CreateServerOptions)CreateServerOptions.class.cast(options.networks(networks));
        }

        public static CreateServerOptions novaNetworks(Iterable<Network> networks) {
            CreateServerOptions options = new CreateServerOptions();
            return (CreateServerOptions)CreateServerOptions.class.cast(options.novaNetworks(networks));
        }

        public static CreateServerOptions availabilityZone(String availabilityZone) {
            CreateServerOptions options = new CreateServerOptions();
            return options.availabilityZone(availabilityZone);
        }
    }

    static class File {
        private final String path;
        private final String contents;

        public File(String path, byte[] contents) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            this.contents = BaseEncoding.base64().encode((byte[])Preconditions.checkNotNull((Object)contents, (Object)"contents"));
            Preconditions.checkArgument((path.getBytes().length < 255 ? 1 : 0) != 0, (Object)String.format("maximum length of path is 255 bytes.  Path specified %s is %d bytes", path, path.getBytes().length));
            Preconditions.checkArgument((contents.length < 10240 ? 1 : 0) != 0, (Object)String.format("maximum size of the file is 10KB.  Contents specified is %d bytes", contents.length));
        }

        public String getContents() {
            return this.contents;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof File) {
                File other = (File)File.class.cast(object);
                return Objects.equal((Object)this.path, (Object)other.path);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.path});
        }

        public String toString() {
            return Objects.toStringHelper((String)"file").add("path", (Object)this.path).toString();
        }
    }

    private static class NamedThingy
    extends ForwardingObject {
        private String name;

        private NamedThingy(String name) {
            this.name = name;
        }

        protected Object delegate() {
            return this.name;
        }
    }

    static class ServerRequest {
        final String name;
        final String imageRef;
        final String flavorRef;
        @Named(value="availability_zone")
        String availabilityZone;
        String adminPass;
        Map<String, String> metadata;
        List<File> personality;
        String key_name;
        @Named(value="security_groups")
        Set<NamedThingy> securityGroupNames;
        String user_data;
        @Named(value="OS-DCF:diskConfig")
        String diskConfig;
        Set<Map<String, String>> networks;
        @Named(value="config_drive")
        String configDrive;

        private ServerRequest(String name, String imageRef, String flavorRef) {
            this.name = name;
            this.imageRef = imageRef;
            this.flavorRef = flavorRef;
        }
    }
}

