/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class HostAggregate {
    private final String id;
    private final String name;
    @Named(value="availability_zone")
    private final String availabilityZone;
    private final Set<String> hosts;
    @Named(value="operational_state")
    private final String state;
    @Named(value="created_at")
    private final Date created;
    @Named(value="updated_at")
    private final Optional<Date> updated;
    private final Map<String, String> metadata;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHostAggregate(this);
    }

    @ConstructorProperties(value={"id", "name", "availability_zone", "hosts", "operational_state", "created_at", "updated_at", "metadata"})
    protected HostAggregate(String id, String name, String availabilityZone, @Nullable Set<String> hosts, String state, Date created, @Nullable Date updated, @Nullable Map<String, String> metadata) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.availabilityZone = (String)Preconditions.checkNotNull((Object)availabilityZone, (Object)"availabilityZone");
        this.hosts = hosts == null ? ImmutableSet.of() : ImmutableSet.copyOf(hosts);
        this.state = (String)Preconditions.checkNotNull((Object)state, (Object)"state");
        this.created = (Date)Preconditions.checkNotNull((Object)created, (Object)"created");
        this.updated = Optional.fromNullable((Object)updated);
        this.metadata = metadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(metadata);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Set<String> getHosts() {
        return this.hosts;
    }

    public String getState() {
        return this.state;
    }

    public Date getCreated() {
        return this.created;
    }

    public Optional<Date> getUpdated() {
        return this.updated;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.availabilityZone, this.hosts, this.state, this.created, this.updated, this.metadata});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostAggregate that = (HostAggregate)HostAggregate.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.availabilityZone, (Object)that.availabilityZone) && Objects.equal(this.hosts, that.hosts) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal(this.updated, that.updated) && Objects.equal(this.metadata, that.metadata);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("availabilityZone", (Object)this.availabilityZone).add("hosts", this.hosts).add("state", (Object)this.state).add("created", (Object)this.created).add("updated", this.updated).add("metadata", this.metadata);
    }

    public String toString() {
        return this.string().toString();
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String availabilityZone;
        protected Set<String> hosts = ImmutableSet.of();
        protected String state;
        protected Date created;
        protected Date updated;
        protected Map<String, String> metadata = ImmutableMap.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this.self();
        }

        public T hosts(Set<String> hosts) {
            this.hosts = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(hosts, (Object)"hosts")));
            return this.self();
        }

        public T hosts(String ... in) {
            return this.hosts((Set<String>)ImmutableSet.copyOf((Object[])in));
        }

        public T state(String state) {
            this.state = state;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T updated(Date updated) {
            this.updated = updated;
            return this.self();
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(metadata, (Object)"metadata")));
            return this.self();
        }

        public HostAggregate build() {
            return new HostAggregate(this.id, this.name, this.availabilityZone, this.hosts, this.state, this.created, this.updated, this.metadata);
        }

        public T fromHostAggregate(HostAggregate in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).availabilityZone(in.getAvailabilityZone())).hosts(in.getHosts())).state(in.getState())).created(in.getCreated())).updated((Date)in.getUpdated().get())).metadata(in.getMetadata());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

