/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class Host {
    @Named(value="host_name")
    private final String name;
    private final String service;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHost(this);
    }

    @ConstructorProperties(value={"host_name", "service"})
    protected Host(@Nullable String name, @Nullable String service) {
        this.name = name;
        this.service = service;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getService() {
        return this.service;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.service});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Host that = (Host)Host.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.service, (Object)that.service);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("service", (Object)this.service);
    }

    public String toString() {
        return this.string().toString();
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected String service;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T service(String service) {
            this.service = service;
            return this.self();
        }

        public Host build() {
            return new Host(this.name, this.service);
        }

        public T fromHost(Host in) {
            return ((Builder)this.name(in.getName())).service(in.getService());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

