/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jclouds.openstack.nova.v2_0.domain.zonescoped;

import static com.google.common.base.Preconditions.checkNotNull;

import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;

public class SecurityGroupInZone extends ZoneAndName {
   protected final SecurityGroup securityGroup;

   public SecurityGroupInZone(SecurityGroup securityGroup, String zoneId) {
      super(zoneId, checkNotNull(securityGroup, "securityGroup").getName());
      this.securityGroup = securityGroup;
   }

   public SecurityGroup getSecurityGroup() {
      return securityGroup;
   }

   // superclass hashCode/equals are good enough, and help us use ZoneAndName and ServerInZone
   // interchangeably as Map keys

   @Override
   public String toString() {
      return "[securityGroup=" + securityGroup + ", zoneId=" + zoneId + "]";
   }

}
