/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.util.Set;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;

public class RunInstancesOptions
extends BaseEC2RequestOptions {
    public static final RunInstancesOptions NONE = new RunInstancesOptions();

    public RunInstancesOptions withKeyName(String keyName) {
        this.formParameters.put((Object)"KeyName", Preconditions.checkNotNull((Object)keyName, (Object)"keyName"));
        return this;
    }

    public RunInstancesOptions withSecurityGroups(String ... securityGroups) {
        this.indexFormValuesWithPrefix("SecurityGroup", securityGroups);
        return this;
    }

    public RunInstancesOptions withSecurityGroups(Iterable<String> securityGroups) {
        this.indexFormValuesWithPrefix("SecurityGroup", securityGroups);
        return this;
    }

    public RunInstancesOptions withSecurityGroup(String securityGroup) {
        return this.withSecurityGroups(securityGroup);
    }

    public RunInstancesOptions withUserData(byte[] unencodedData) {
        int length = ((byte[])Preconditions.checkNotNull((Object)unencodedData, (Object)"unencodedData")).length;
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"userData cannot be empty");
        Preconditions.checkArgument((length <= 16384 ? 1 : 0) != 0, (Object)"userData cannot be larger than 16kb");
        this.formParameters.put((Object)"UserData", (Object)BaseEncoding.base64().encode(unencodedData));
        return this;
    }

    public RunInstancesOptions asType(String type) {
        this.formParameters.put((Object)"InstanceType", Preconditions.checkNotNull((Object)type, (Object)"type"));
        return this;
    }

    public RunInstancesOptions withKernelId(String kernelId) {
        this.formParameters.put((Object)"KernelId", Preconditions.checkNotNull((Object)kernelId, (Object)"kernelId"));
        return this;
    }

    public RunInstancesOptions withRamdisk(String ramDiskId) {
        this.formParameters.put((Object)"RamdiskId", Preconditions.checkNotNull((Object)ramDiskId, (Object)"ramDiskId"));
        return this;
    }

    public RunInstancesOptions withBlockDeviceMappings(Set<? extends BlockDeviceMapping> mappings) {
        int i = 1;
        for (BlockDeviceMapping mapping : (Set)Preconditions.checkNotNull(mappings, (Object)"mappings")) {
            Preconditions.checkNotNull((Object)mapping.getDeviceName(), (Object)"deviceName");
            this.formParameters.put((Object)String.format("BlockDeviceMapping.%d.DeviceName", i), (Object)mapping.getDeviceName());
            if (mapping.getVirtualName() != null) {
                this.formParameters.put((Object)String.format("BlockDeviceMapping.%d.VirtualName", i), (Object)mapping.getVirtualName());
            }
            if (mapping.getEbsSnapshotId() != null) {
                this.formParameters.put((Object)String.format("BlockDeviceMapping.%d.Ebs.SnapshotId", i), (Object)mapping.getEbsSnapshotId());
            }
            if (mapping.getEbsVolumeSize() != null) {
                this.formParameters.put((Object)String.format("BlockDeviceMapping.%d.Ebs.VolumeSize", i), (Object)String.valueOf(mapping.getEbsVolumeSize()));
            }
            if (mapping.getEbsNoDevice() != null) {
                this.formParameters.put((Object)String.format("BlockDeviceMapping.%d.Ebs.NoDevice", i), (Object)String.valueOf(mapping.getEbsNoDevice()));
            }
            if (mapping.getEbsDeleteOnTermination() != null) {
                this.formParameters.put((Object)String.format("BlockDeviceMapping.%d.Ebs.DeleteOnTermination", i), (Object)String.valueOf(mapping.getEbsDeleteOnTermination()));
            }
            if (mapping.getEbsVolumeType() != null) {
                this.formParameters.put((Object)String.format("BlockDeviceMapping.%d.Ebs.VolumeType", i), (Object)mapping.getEbsVolumeType());
            }
            if (mapping.getEbsIops() != null) {
                this.formParameters.put((Object)String.format("BlockDeviceMapping.%d.Ebs.Iops", i), (Object)String.valueOf(mapping.getEbsIops()));
            }
            if (mapping.getEbsEncrypted() != null && mapping.getEbsEncrypted().booleanValue()) {
                this.formParameters.put((Object)String.format("BlockDeviceMapping.%d.Ebs.Encrypted", i), (Object)String.valueOf(mapping.getEbsEncrypted()));
            }
            ++i;
        }
        return this;
    }

    public RunInstancesOptions withClientToken(String clientToken) {
        this.formParameters.put((Object)"ClientToken", Preconditions.checkNotNull((Object)clientToken, (Object)"clientToken"));
        return this;
    }

    public static class Builder {
        public static RunInstancesOptions withKeyName(String keyName) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withKeyName(keyName);
        }

        public static RunInstancesOptions withSecurityGroup(String securityGroup) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withSecurityGroup(securityGroup);
        }

        public static RunInstancesOptions withUserData(byte[] unencodedData) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withUserData(unencodedData);
        }

        public static RunInstancesOptions asType(String instanceType) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.asType(instanceType);
        }

        public static RunInstancesOptions withKernelId(String kernelId) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withKernelId(kernelId);
        }

        public static RunInstancesOptions withRamdisk(String ramdiskId) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withRamdisk(ramdiskId);
        }

        public static RunInstancesOptions withBlockDeviceMappings(Set<? extends BlockDeviceMapping> mappings) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withBlockDeviceMappings(mappings);
        }

        public static RunInstancesOptions withClientToken(String clientToken) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withClientToken(clientToken);
        }
    }
}

