/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import org.jclouds.Fallback;
import org.jclouds.aws.AWSResponseException;

public final class EC2Fallbacks {
    private EC2Fallbacks() {
    }

    public static final class VoidOnVolumeAvailable
    implements Fallback<Void> {
        public ListenableFuture<Void> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Void createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull((Object)t, (Object)"throwable") instanceof AWSResponseException) {
                AWSResponseException e = (AWSResponseException)((Object)AWSResponseException.class.cast(t));
                if (Predicates.in((Collection)ImmutableSet.of((Object)"IncorrectState", (Object)"available")).apply((Object)e.getError().getCode())) {
                    return null;
                }
            }
            throw Throwables.propagate((Throwable)t);
        }
    }
}

