/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;

@Beta
public class GetMetricStatistics {
    private final Set<Dimension> dimensions;
    private final Optional<Date> endTime;
    private final String metricName;
    private final String namespace;
    private final int period;
    private final Optional<Date> startTime;
    private final Set<Statistics> statistics;
    private final Optional<Unit> unit;

    protected GetMetricStatistics(Set<Dimension> dimensions, Date endTime, String metricName, String namespace, int period, Date startTime, Set<Statistics> statistics, Unit unit) {
        this.dimensions = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(dimensions, (Object)"dimensions")));
        this.endTime = Optional.fromNullable((Object)endTime);
        this.metricName = (String)Preconditions.checkNotNull((Object)metricName, (Object)"metricName");
        this.namespace = (String)Preconditions.checkNotNull((Object)namespace, (Object)"namespace");
        this.period = period;
        this.startTime = Optional.fromNullable((Object)startTime);
        this.statistics = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(statistics, (Object)"statistics")));
        this.unit = Optional.fromNullable((Object)((Object)unit));
    }

    public Set<Dimension> getDimensions() {
        return this.dimensions;
    }

    public Optional<Date> getEndTime() {
        return this.endTime;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getPeriod() {
        return this.period;
    }

    public Optional<Date> getStartTime() {
        return this.startTime;
    }

    public Set<Statistics> getStatistics() {
        return this.statistics;
    }

    public Optional<Unit> getUnit() {
        return this.unit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<Dimension> dimensions = Sets.newLinkedHashSet();
        private Date endTime;
        private String metricName;
        private String namespace;
        private int period = 60;
        private Date startTime;
        private Set<Statistics> statistics = Sets.newLinkedHashSet();
        private Unit unit;

        public Builder dimensions(Set<Dimension> dimensions) {
            this.dimensions.addAll((Collection)Preconditions.checkNotNull(dimensions, (Object)"dimensions"));
            return this;
        }

        public Builder dimension(Dimension dimension) {
            this.dimensions.add((Dimension)Preconditions.checkNotNull((Object)dimension, (Object)"dimension"));
            return this;
        }

        public Builder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder period(int period) {
            this.period = period;
            return this;
        }

        public Builder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder statistics(Set<Statistics> statistics) {
            this.statistics.addAll((Collection)Preconditions.checkNotNull(statistics, (Object)"statistics"));
            return this;
        }

        public Builder statistic(Statistics statistic) {
            this.statistics.add((Statistics)((Object)Preconditions.checkNotNull((Object)((Object)statistic), (Object)"statistic")));
            return this;
        }

        public Builder unit(Unit unit) {
            this.unit = unit;
            return this;
        }

        public GetMetricStatistics build() {
            return new GetMetricStatistics(this.dimensions, this.endTime, this.metricName, this.namespace, this.period, this.startTime, this.statistics, this.unit);
        }
    }
}

