/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.project3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class TaskCodeSimpleOrder implements Comparator<TaskCode> {

	private final List<TaskCode> order;
	private final int hierarchySize;

	public TaskCodeSimpleOrder(Collection<TaskCode> order, int hierarchySize) {
		this.order = new ArrayList<TaskCode>(order);
		this.hierarchySize = hierarchySize;
		for (TaskCode code : order) {
			if (code.getHierarchySize() != hierarchySize) {
				throw new IllegalArgumentException();
			}
		}
	}

	public int compare(TaskCode code1, TaskCode code2) {
		if (code1.getHierarchySize() < hierarchySize) {
			throw new IllegalArgumentException();
		}
		if (code2.getHierarchySize() < hierarchySize) {
			throw new IllegalArgumentException();
		}
		code1 = code1.truncateHierarchy(hierarchySize);
		code2 = code2.truncateHierarchy(hierarchySize);
		final int idx1 = order.indexOf(code1);
		final int idx2 = order.indexOf(code2);
		return idx1 - idx2;
	}
}
