/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.project3;

public class LoadInDays implements Load {

	private final int days;
	private final int loadPerDay;

	private LoadInDays(int days, int loadPerDay) {
		this.days = days;
		this.loadPerDay = loadPerDay;
	}

	public static LoadInDays inDay(int days) {
		return new LoadInDays(days, 100);
	}

	public static Complement inDayWithLoad(int days, int loadPerDay) {
		final int tmp = (int) Math.ceil(days * 100.0 / loadPerDay);
		return new LoadInDays(tmp, loadPerDay);
	}

	public int getFullLoad() {
		return days * loadPerDay;
	}

	public int getLoadAt(Instant instant) {
		return loadPerDay;
	}

}
