/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.postit;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Area implements Elastic {

	private final String title;
	private final char id;

	private Dimension2D minimumDimension;

	private final List<PostIt> postIts = new ArrayList<PostIt>();

	public Area(char id, String title) {
		this.id = id;
		this.title = title;
	}

	public char getId() {
		return id;
	}

	public String getTitle() {
		return title;
	}

	public Dimension2D getMinimumDimension() {
		return minimumDimension;
	}

	public void setMinimunDimension(Dimension2D minimumDimension) {
		this.minimumDimension = minimumDimension;
	}

	public Dimension2D getDimension() {
		throw new UnsupportedOperationException();
	}

	public double heightWhenWidthIs(double width, StringBounder stringBounder) {
		final AreaLayoutFixedWidth layout = new AreaLayoutFixedWidth(width);
		final Map<PostIt, Point2D> pos = layout.getPositions(postIts, stringBounder);
		double max = 10;
		for (Map.Entry<PostIt, Point2D> ent : pos.entrySet()) {
			final double y = ent.getKey().getDimension(stringBounder).getHeight() + ent.getValue().getY();
			max = Math.max(max, y);
		}

		return max + 10;
	}

	public double widthWhenHeightIs(double height, StringBounder stringBounder) {
		throw new UnsupportedOperationException();
	}

	public void add(PostIt postIt) {
		postIts.add(postIt);
	}

	public void drawU(UGraphic ug, double width) {
		final AreaLayout layout = new AreaLayoutFixedWidth(width);
		final Map<PostIt, Point2D> pos = layout.getPositions(postIts, ug.getStringBounder());
		for (Map.Entry<PostIt, Point2D> ent : pos.entrySet()) {
			final UGraphic ugTranslated = ug.apply(new UTranslate(ent.getValue().getX(), ent.getValue().getY()));
			ent.getKey().drawU(ugTranslated);
		}

	}

}
