/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.png;

class PngSegment {

	private final int totalSize;
	private final int nbPiece;

	public PngSegment(int totalSize, int nbPiece) {
		this.nbPiece = nbPiece;
		this.totalSize = totalSize;
	}

	public int getStart(int idx) {
		if (idx < 0 || idx > nbPiece - 1) {
			throw new IllegalArgumentException();
		}
		return (int) (1.0 * totalSize / nbPiece * idx);
	}

	public int getLen(int idx) {
		if (idx < 0 || idx > nbPiece - 1) {
			throw new IllegalArgumentException();
		}
		return (int) (1.0 * totalSize / nbPiece);
	}

}
