/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.jungle;

import java.util.List;

import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Needle implements UDrawable {

	private final double length;
	private final Display display;
	private final double degreePosition;
	private final double degreeOperture;

	private Needle(Display display, double length, double degreePosition, double degreeOperture) {
		this.display = display;
		this.degreePosition = degreePosition;
		this.degreeOperture = degreeOperture;
		this.length = length;
	}

	public void drawU(UGraphic ug) {
		GTileNode.getTextBlock(display);
		ug.draw(getLine());

		ug = ug.apply(getTranslate(length));
		GTileNode.getTextBlock(display).drawU(ug);
	}

	private ULine getLine() {
		final UTranslate translate = getTranslate(length);
		return new ULine(translate.getDx(), translate.getDy());
	}

	public UTranslate getTranslate(double dist) {
		final double angle = degreePosition * Math.PI / 180.0;
		final double dx = dist * Math.cos(angle);
		final double dy = dist * Math.sin(angle);
		return new UTranslate(dx, dy);
	}

	public UDrawable addChildren(final List<GNode> children) {
		return new UDrawable() {
			public void drawU(UGraphic ug) {
				Needle.this.drawU(ug);
				if (children.size() == 0) {
					return;
				}
				ug = ug.apply(getTranslate(length / 2));
				final UDrawable child1 = getNeedle(children.get(0), length / 2, degreePosition + degreeOperture,
						degreeOperture / 2);
				child1.drawU(ug);
				if (children.size() == 1) {
					return;
				}
				final UDrawable child2 = getNeedle(children.get(1), length / 2, degreePosition - degreeOperture,
						degreeOperture / 2);
				child2.drawU(ug);

			}
		};
	}

	public static UDrawable getNeedle(GNode root, double length, double degree, double degreeOperture) {
		final Needle needle0 = new Needle(root.getDisplay(), length, degree, degreeOperture);
		final UDrawable n1 = needle0.addChildren(root.getChildren());
		return new UDrawable() {
			public void drawU(UGraphic ug) {
				ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
				n1.drawU(ug);
			}
		};
	}

}
